/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.priviledges.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jfrog.storage.priviledges.DBPrivilegesVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDbPrivilegesVerifier
implements DBPrivilegesVerifier {
    private static final Logger log = LoggerFactory.getLogger(OracleDbPrivilegesVerifier.class);
    private static final String DROP_TABLE2_STRING = "DROP TABLE t2<suffix>";
    private static final String DROP_TABLE1_STRING = "DROP TABLE t1<suffix>";
    private static final String CREATE_TABLE1_STRING = "CREATE TABLE t1<suffix> (   ppkey             NUMBER(5, 0),    CONSTRAINT t1id<suffix> PRIMARY KEY (ppkey) )";
    private static final String CREATE_TABLE2_STRING = "CREATE TABLE t2<suffix> (\n  id             NUMBER(5, 0),   ffkey         NUMBER(5, 0),   CONSTRAINT id<suffix> PRIMARY KEY (id),   CONSTRAINT t2_fk<suffix> FOREIGN KEY (ffkey) REFERENCES t1<suffix> (ppkey))";

    @Override
    public boolean isSufficientPrivileges(Connection con, String caller) {
        try (Statement stmt = con.createStatement();){
            try {
                stmt.executeUpdate(DROP_TABLE2_STRING.replaceAll("<suffix>", caller));
                stmt.executeUpdate(DROP_TABLE1_STRING.replaceAll("<suffix>", caller));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt.executeUpdate(CREATE_TABLE1_STRING.replaceAll("<suffix>", caller));
            stmt.executeUpdate(CREATE_TABLE2_STRING.replaceAll("<suffix>", caller));
            stmt.executeUpdate(DROP_TABLE2_STRING.replaceAll("<suffix>", caller));
            stmt.executeUpdate(DROP_TABLE1_STRING.replaceAll("<suffix>", caller));
        }
        catch (Exception e) {
            log.error("Could not determine sufficient privileges", (Throwable)e);
            throw new RuntimeException(e);
        }
        return true;
    }
}

