/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.priviledges;

import java.sql.Connection;
import java.sql.Statement;
import org.jfrog.storage.priviledges.DBPrivilegesVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDBPrivilegesVerifier
implements DBPrivilegesVerifier {
    private static final Logger log = LoggerFactory.getLogger(GenericDBPrivilegesVerifier.class);
    private static final String DROP_TABLES_STRING = "DROP TABLE t2<suffix>, t1<suffix>";
    private static final String CREATE_TABLE1_STRING = "CREATE TABLE t1<suffix> (\n  ppkey             BIGINT, \n  CONSTRAINT t1id<suffix> PRIMARY KEY (ppkey)\n)";
    private static final String CREATE_TABLE2_STRING = "CREATE TABLE t2<suffix> (\n  id             BIGINT,\n  ffkey         BIGINT,\n  CONSTRAINT id<suffix> PRIMARY KEY (id),\n  CONSTRAINT t2_fk<suffix> FOREIGN KEY (ffkey) REFERENCES t1<suffix> (ppkey)\n);";

    @Override
    public boolean isSufficientPrivileges(Connection con, String caller) {
        try (Statement stmt = con.createStatement();){
            try {
                stmt.executeUpdate(DROP_TABLES_STRING.replaceAll("<suffix>", caller));
            }
            catch (Exception exception) {
                // empty catch block
            }
            stmt.executeUpdate(CREATE_TABLE1_STRING.replaceAll("<suffix>", caller));
            stmt.executeUpdate(CREATE_TABLE2_STRING.replaceAll("<suffix>", caller));
            stmt.executeUpdate(DROP_TABLES_STRING.replaceAll("<suffix>", caller));
        }
        catch (Exception e) {
            log.error("Could not determine sufficient privileges", (Throwable)e);
            throw new RuntimeException(e);
        }
        return true;
    }
}

