/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.priviledges;

import org.jfrog.storage.DbType;
import org.jfrog.storage.priviledges.DBPrivilegesVerifier;
import org.jfrog.storage.priviledges.derby.DerbyPriviledgesVerifier;
import org.jfrog.storage.priviledges.mssql.MssqlDBPrivilegesVerifier;
import org.jfrog.storage.priviledges.mysql.MysqlDBPrivilegesVerifier;
import org.jfrog.storage.priviledges.oracle.OracleDbPrivilegesVerifier;
import org.jfrog.storage.priviledges.postgres.PostgresDBPrivilegesVerifier;

public class DBPrivilegesVerifierFactory {
    public static DBPrivilegesVerifier createDBPrivilegesVerifier(DbType dbtype) {
        switch (dbtype) {
            case MYSQL: {
                return new MysqlDBPrivilegesVerifier();
            }
            case ORACLE: {
                return new OracleDbPrivilegesVerifier();
            }
            case MSSQL: {
                return new MssqlDBPrivilegesVerifier();
            }
            case POSTGRESQL: {
                return new PostgresDBPrivilegesVerifier();
            }
            case DERBY: {
                return new DerbyPriviledgesVerifier();
            }
            case MARIADB: {
                return new MysqlDBPrivilegesVerifier();
            }
        }
        throw new RuntimeException(dbtype.name() + " Not supported");
    }
}

