/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.jfrog.storage.DbProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatJDBCDataSource
extends DataSource
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TomcatJDBCDataSource.class);

    public TomcatJDBCDataSource(DbProperties s) {
        PoolProperties p = new PoolProperties();
        p.setUrl(s.getConnectionUrl());
        p.setDriverClassName(s.getDriverClass());
        p.setUsername(s.getUsername());
        p.setPassword(s.getPassword());
        p.setDefaultAutoCommit(Boolean.valueOf(s.getBooleanProperty("defaultAutoCommit", true)));
        p.setDefaultTransactionIsolation(2);
        p.setInitialSize(s.getIntProperty("initialSize", 1));
        p.setMaxAge((long)s.getIntProperty("maxAge", 0));
        p.setMaxActive(s.getMaxActiveConnections());
        p.setMaxWait(s.getIntProperty("maxWait", (int)TimeUnit.SECONDS.toMillis(120L)));
        p.setMaxIdle(s.getMaxIdleConnections());
        p.setMinIdle(s.getIntProperty("minIdle", 1));
        p.setMinEvictableIdleTimeMillis(s.getIntProperty("minEvictableIdleTimeMillis", 300000));
        p.setTimeBetweenEvictionRunsMillis(s.getIntProperty("timeBetweenEvictionRunsMillis", 30000));
        p.setInitSQL(s.getProperty("initSQL", null));
        p.setValidationQuery(s.getProperty("validationQuery", TomcatJDBCDataSource.getDefaultValidationQuery(s)));
        p.setValidationQueryTimeout(s.getIntProperty("validationQueryTimeout", 30));
        p.setValidationInterval(s.getLongProperty("validationInterval", 30000L));
        p.setTestOnBorrow(s.getBooleanProperty("testOnBorrow", true));
        p.setTestWhileIdle(s.getBooleanProperty("testWhileIdle", false));
        p.setTestOnReturn(s.getBooleanProperty("testOnReturn", false));
        p.setTestOnConnect(s.getBooleanProperty("testOnConnect", false));
        p.setRemoveAbandoned(s.getBooleanProperty("removeAbandoned", false));
        p.setRemoveAbandonedTimeout(s.getIntProperty("removeAbandonedTimeout", 600));
        p.setSuspectTimeout(s.getIntProperty("suspectTimeout", 600));
        p.setLogAbandoned(s.getBooleanProperty("logAbandoned", false));
        p.setLogValidationErrors(s.getBooleanProperty("logValidationErrors", false));
        p.setJmxEnabled(s.getBooleanProperty("jmxEnabled", true));
        p.setRollbackOnReturn(s.getBooleanProperty("rollbackOnReturn", false));
        p.setCommitOnReturn(s.getBooleanProperty("commitOnReturn", false));
        p.setIgnoreExceptionOnPreLoad(s.getBooleanProperty("ignoreExceptionOnPreLoad", false));
        p.setJdbcInterceptors(s.getProperty("jdbcInterceptors", null));
        p.setDefaultCatalog(s.getProperty("defaultCatalog", null));
        this.setPoolProperties((PoolConfiguration)p);
    }

    public static DataSource createUniqueIdDataSource(DbProperties s) {
        PoolProperties p = new PoolProperties();
        p.setName("UniqueIdDataSource");
        p.setUrl(s.getConnectionUrl());
        p.setDriverClassName(s.getDriverClass());
        p.setUsername(s.getUsername());
        p.setPassword(s.getPassword());
        p.setDefaultAutoCommit(Boolean.valueOf(true));
        p.setDefaultTransactionIsolation(2);
        p.setInitialSize(0);
        p.setMinIdle(0);
        p.setMaxIdle(1);
        p.setMaxActive(2);
        long timeoutInMillis = TimeUnit.SECONDS.toMillis(s.getIntProperty("locksTimeout", 120));
        p.setTestWhileIdle(true);
        p.setTestOnBorrow(true);
        p.setTestWhileIdle(true);
        p.setRemoveAbandoned(true);
        p.setRemoveAbandonedTimeout((int)timeoutInMillis / 2);
        p.setSuspectTimeout((int)timeoutInMillis / 2);
        p.setLogAbandoned(true);
        p.setLogValidationErrors(true);
        p.setMaxAge(timeoutInMillis);
        p.setMaxWait((int)timeoutInMillis);
        if (!p.isPoolSweeperEnabled()) {
            log.error("ID Generator pool connection should sweep idled connections");
        }
        p.setInitSQL(s.getProperty("initSQL", null));
        p.setValidationQuery(s.getProperty("validationQuery", TomcatJDBCDataSource.getDefaultValidationQuery(s)));
        p.setValidationQueryTimeout(s.getIntProperty("validationQueryTimeout", 30));
        p.setValidationInterval(s.getLongProperty("validationInterval", 30000L));
        p.setJmxEnabled(false);
        p.setIgnoreExceptionOnPreLoad(s.getBooleanProperty("ignoreExceptionOnPreLoad", false));
        p.setJdbcInterceptors(s.getProperty("jdbcInterceptors", "ConnectionState"));
        p.setDefaultCatalog(s.getProperty("defaultCatalog", null));
        return new DataSource((PoolConfiguration)p);
    }

    private static String getDefaultValidationQuery(DbProperties s) {
        switch (s.getDbType()) {
            case DERBY: {
                return "values(1)";
            }
            case MYSQL: {
                return "/* ping */";
            }
            case ORACLE: {
                return "SELECT 1 FROM DUAL";
            }
        }
        return "SELECT 1";
    }

    @Override
    public void close() {
        this.close(true);
    }
}

