/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedProperties
extends Properties {
    private static final Logger log = LoggerFactory.getLogger(LinkedProperties.class);
    private LinkedHashMap<String, String> linkedProps = new LinkedHashMap();
    private int commentCount;

    public static String toString(String key, String value) {
        if (key.charAt(0) == '#') {
            return value;
        }
        return key + "=" + value;
    }

    @Override
    public String getProperty(String key) {
        return this.linkedProps.get(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String propKey = this.linkedProps.get(key);
        if (propKey != null) {
            return propKey;
        }
        return defaultValue;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.linkedProps.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.linkedProps.containsKey(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.linkedProps.containsValue(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.linkedProps.containsKey(key);
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.linkedProps.remove(key);
    }

    @Override
    public synchronized void putAll(Map<?, ?> map) {
        map.entrySet().forEach((? super T entry) -> this.put(entry.getKey(), entry.getValue()));
    }

    @Override
    public synchronized void clear() {
        this.linkedProps.clear();
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException("keySet() not supported as this class manages only property String:String");
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        throw new UnsupportedOperationException("entrySet() not supported as this class manages only property String:String");
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException("values() not supported as this class manages only property String:String");
    }

    @Override
    public synchronized Object getOrDefault(Object key, Object defaultValue) {
        return this.linkedProps.getOrDefault(key, (String)defaultValue);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.linkedProps.forEach(action);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
        this.linkedProps.replaceAll(function);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        return this.linkedProps.putIfAbsent((String)key, (String)value);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        return this.linkedProps.remove(key, value);
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        return this.linkedProps.replace((String)key, (String)oldValue, (String)newValue);
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        return this.linkedProps.replace((String)key, (String)value);
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
        return this.linkedProps.computeIfAbsent((String)key, mappingFunction);
    }

    @Override
    public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.linkedProps.computeIfPresent((String)key, remappingFunction);
    }

    @Override
    public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.linkedProps.compute((String)key, remappingFunction);
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.linkedProps.merge((String)key, (String)value, remappingFunction);
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        throw new UnsupportedOperationException("elements() not supported as this class manages only property String:String");
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        throw new UnsupportedOperationException("keys() not supported as this class manages only property String:String");
    }

    @Override
    public synchronized Object get(Object key) {
        return this.linkedProps.get(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.linkedProps.put((String)key, (String)value);
    }

    @Override
    public synchronized int size() {
        return this.linkedProps.size();
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        String trimmed = StringUtils.trimToEmpty((String)value);
        return this.linkedProps.put(key, trimmed);
    }

    private void setLine(String data, int lineNo) {
        int state = 0;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        block9: for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block9;
                    state = 1;
                    --i;
                    continue block9;
                }
                case 1: {
                    if (c == '#' || c == '!') {
                        i = data.length();
                        continue block9;
                    }
                    key.append(c);
                    state = 2;
                    continue block9;
                }
                case 2: {
                    if (Character.isWhitespace(c) || c == '=' || c == ':') {
                        state = 3;
                        --i;
                        continue block9;
                    }
                    key.append(c);
                    continue block9;
                }
                case 3: {
                    if (Character.isWhitespace(c)) continue block9;
                    state = 4;
                    --i;
                    continue block9;
                }
                case 4: {
                    if (c == '=' || c == ':') {
                        state = 5;
                        continue block9;
                    }
                    throw new IllegalArgumentException("Line in properties file is malformed: " + lineNo);
                }
                case 5: {
                    if (Character.isWhitespace(c)) continue block9;
                    state = 6;
                    --i;
                    continue block9;
                }
                case 6: {
                    value.append(c);
                }
            }
        }
        if (key.length() == 0) {
            this.addComment(data);
        } else {
            this.linkedProps.put(key.toString(), value.toString());
        }
    }

    public void addComment(String comment) {
        this.linkedProps.put("#" + ++this.commentCount, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String fname) throws IOException {
        File file = new File(fname);
        if (file.exists() && file.isFile()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                this.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException ex) {
                        log.error("Error Loading properties File" + ex.getMessage(), (Object)ex, (Object)log);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void load(InputStream inputStream) throws IOException {
        this.load(new InputStreamReader(inputStream));
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        String dataLine;
        int lineNo = 0;
        this.commentCount = 0;
        BufferedReader in = new BufferedReader(reader);
        while ((dataLine = in.readLine()) != null) {
            this.setLine(dataLine, ++lineNo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String fName, String comment) throws IOException {
        File file = new File(fName);
        if (file.exists() && !file.isFile()) {
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            this.store(outputStream, comment);
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException ex) {
                    log.error("Error Saving properties File" + ex.getMessage(), (Object)ex, (Object)log);
                }
            }
        }
    }

    @Override
    public void store(OutputStream out, String comment) throws IOException {
        this.store(new PrintWriter(out, true), comment);
    }

    @Override
    public void store(Writer writer, String comment) throws IOException {
        this.store(new PrintWriter(writer, true), comment);
    }

    public void store(PrintWriter out, String comment) throws IOException {
        Set<String> keySet = this.linkedProps.keySet();
        for (String key : keySet) {
            out.println(LinkedProperties.toString(key, this.linkedProps.get(key)));
        }
    }

    @Override
    public void list(PrintStream out) {
        Set<String> keySet = this.linkedProps.keySet();
        for (String key : keySet) {
            out.println(LinkedProperties.toString(key, this.linkedProps.get(key)));
        }
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.linkedProps.entrySet().iterator();
    }
}

