package org.jfrog.storage.dbtype;

import org.jfrog.storage.DbType;

import javax.annotation.Nonnull;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * @author Noam Shemesh
 */
public class OracleSpecificHelper extends DefaultDbTypeHelper {
    @Nonnull
    @Override
    public DbType getType() {
        return DbType.ORACLE;
    }

    @Override
    public String getInsertMultipleValuesSql(String tableAndFields, String valuesSql, int numberOfValues) {
        return "INSERT ALL " +
                IntStream.range(0, numberOfValues)
                        .mapToObj(i -> " INTO " + tableAndFields + " VALUES " + valuesSql)
                        .collect(Collectors.joining(" ", "", " SELECT * FROM dual"));
    }
}
