package org.jfrog.storage.dbtype;

import org.jfrog.storage.DbType;

import java.util.List;

/**
 * @author Noam Shemesh
 */
public interface DbSpecificHelper {
    /**
     * @return The name of the database
     */
    DbType getType();

    /**
     * A helper method to return the sql syntax just as in different databases
     */
    String getInsertMultipleValuesSql(String tableAndFields, String valuesSql, int numberOfValues);

    String getDeleteMultipleValuesSql(String tableAndFields, String valuesSql, int numberOfValues);

    String getDeleteMultipleColumnsMultipleValuesSql(String tableAndOtherConditions, List<String> conditionColumns,
            int numberOfValues);

    String getQueryMultipleValuesSql(String returnedValues, String tableAndFields, String valuesSql, int numberOfValues);

    /**
     * Example: SELECT returnedValues FROM tableAndOtherFields (col1 = ? AND col2 = ?) OR (col1 = ? AND col2 = ?)
     */
    String getQueryMultipleColumnsMultipleValuesSql(String returnedValues, String tableAndOtherFields,
            List<String> columns, int numberOfValues);
}