/*
 *
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2016 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.storage.util;

import org.springframework.transaction.support.TransactionSynchronizationManager;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * @author Chen Keinan
 */
public class TxHelper {


    /**
     * check if thread in mid of spring transactional
     *
     * @return if true - it in spring transactional
     */
    public static boolean isInTransaction() {
        return TransactionSynchronizationManager.isSynchronizationActive();
    }

    /**
     * set isolation level to read uncommitted in case of aql queries
     *
     * @param allowDirtyReads - if true set isolation level to  read uncommitted
     * @param con             - sql connection
     * @throws SQLException
     */
    public static void allowDirtyReads(boolean allowDirtyReads, Connection con) throws SQLException {
        if (allowDirtyReads && con != null) {
            con.setTransactionIsolation(Connection.TRANSACTION_READ_UNCOMMITTED);
        }
    }

    /**
     * set isolation level to read committed in case of aql queries completed
     *
     * @param allowDirtyReads - if true set isolation level to  read committed
     * @param con             - sql connection
     * @throws SQLException
     */
    public static void disableDirtyReads(boolean allowDirtyReads, Connection con) throws SQLException {
        if (allowDirtyReads && con != null) {
            con.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
        }
    }
}
