package org.jfrog.storage.util;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author Yinon Avraham.
 */
public abstract class DaoUtils {

    private DaoUtils() {
        //utility
    }

    public static Long nullIfZero(long value) {
        return (value == 0L) ? null : value;
    }

    // TODO [by FSI] : Looks useless since JDBS doing it no?
    public static long zeroIfNull(Long value) {
        return (value == null) ? 0L : value;
    }

    // TODO [by FSI] : Looks useless since JDBS doing it no?
    public static int zeroIfNull(Integer value) {
        return (value == null) ? 0 : value;
    }

    public static Long nullIfZeroOrNegative(long value) {
        return (value <= 0L) ? null : value;
    }

    public static Integer nullIfZeroOrNegative(int value) {
        return (value <= 0L) ? null : value;
    }

    public static long zeroIfNullOrNegative(Long value) {
        return value == null || value < 0 ? 0 : value;
    }

    public static int zeroIfNullOrNegative(Integer value) {
        return value == null || value < 0 ? 0 : value;
    }

    public static String emptyIfNull(String value) {
        return value == null ? "" : value;
    }

    public static String nullIfEmpty(String value) {
        return (value == null || value.length() == 0) ? null : value;
    }

    public static String enumToStringOrNull(Enum enumValue) {
        if (enumValue != null) {
            return enumValue.name();
        }
        return null;
    }

    /**
     * Turns boolean to byte value (0, 1) for cross database compatibility.
     *
     * @param bool The boolean value
     * @return 0 if boolean is false, 1 if true
     */
    public static byte booleanAsByte(boolean bool) {
        return (byte) (bool ? 1 : 0);
    }

    /**
     * Get a long value from a nullable numeric column in the result set
     * @param resultSet the result set from which to get the value
     * @param columnLabel the column label
     * @return the long value or <code>null</code>
     * @throws SQLException
     */
    public static Long getLongOrNull(ResultSet resultSet, String columnLabel) throws SQLException {
        Object value = resultSet.getObject(columnLabel);
        return value == null ? null : ((Number) value).longValue();
    }
}
