package org.jfrog.storage.priviledges;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Connection;
import java.sql.Statement;


public class GenericDBPrivilegesVerifier implements DBPrivilegesVerifier {

    private final static Logger log = LoggerFactory.getLogger(
            GenericDBPrivilegesVerifier.class);

    private final static String DROP_TABLES_STRING = "DROP TABLE t2<suffix>, t1<suffix>";

    private static final String CREATE_TABLE1_STRING =
            "CREATE TABLE t1<suffix> (\n" +
                    "  ppkey             BIGINT, \n" +
                    "  CONSTRAINT t1id<suffix> PRIMARY KEY (ppkey)\n" +
                    ")";


    private static final String CREATE_TABLE2_STRING =
            "CREATE TABLE t2<suffix> (\n" +
                    "  id             BIGINT,\n" +
                    "  ffkey         BIGINT,\n" +
                    "  CONSTRAINT id<suffix> PRIMARY KEY (id),\n" +
                    "  CONSTRAINT t2_fk<suffix> FOREIGN KEY (ffkey) REFERENCES t1<suffix> (ppkey)\n" +
                    ");";


    @Override
    public boolean isSufficientPrivileges(Connection con, String caller) {
        try (Statement stmt = con.createStatement()) {
            try {
                stmt.executeUpdate(DROP_TABLES_STRING.replaceAll("<suffix>", caller));
            } catch (Exception ignore) {}
            stmt.executeUpdate(CREATE_TABLE1_STRING.replaceAll("<suffix>", caller));
            stmt.executeUpdate(CREATE_TABLE2_STRING.replaceAll("<suffix>", caller));
            stmt.executeUpdate(DROP_TABLES_STRING.replaceAll("<suffix>", caller));
        } catch (Exception e) {
            log.error("Could not determine sufficient privileges", e);
            throw new RuntimeException(e);
        }
        return true;
    }
}
