package org.jfrog.storage.binstore.ifc;

import org.jfrog.access.client.AccessClient;
import org.jfrog.common.concurrency.LockingMapFactoryProvider;

import java.util.Properties;
import java.util.function.Supplier;

/**
 * @author Fred Simon on 9/7/16.
 */
public interface BinaryStoreContext {

    LockingMapFactoryProvider getLockingMapFactoryProvider();

    Properties getHaProperties();

    /**
     * @return True if the input sha1 exists in the binary store database
     */
    boolean exists(String sha1);

    AccessClient getAccessClient();

    Supplier<String> getTraceIdSupplier();
}
