/*
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2016 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.storage.binstore.ifc;

import org.jfrog.access.client.AccessClient;
import org.jfrog.storage.binstore.ifc.model.BinaryElement;
import org.jfrog.storage.binstore.ifc.provider.BinaryProvider;

import java.io.InputStream;
import java.util.Map;
import java.util.function.Supplier;

/**
 * @author Fred Simon
 */
public interface BinaryProviderManagerBase {

    BinaryStoreContext getBinaryStoreContext();

    BinaryProvider getFirstBinaryProvider();

    BinaryElement createBinaryElement(String sha1, String sha2, String md5, long length);

    BinaryStream createBinaryStream(InputStream in);

    BinaryStream createBinaryStream(InputStream in, Map<String, String> headers);

    AccessClient getAccessClient();

    String getAccessServiceId();

    Supplier<String> getTraceIdSupplier();
}
