/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.binstore.exceptions;

import org.jfrog.storage.binstore.exceptions.ResponseReadyException;

public class BinaryRejectedException
extends RuntimeException
implements ResponseReadyException {
    private static final int CODE = 409;
    private static final String ERROR = "Mismatch between expected %s: '%s' and actual calculated checksum of this stream: '%s'. The Binary is rejected and will not be saved.";

    public BinaryRejectedException(String checksumType, String expectedChecksum, String actualChecksum) {
        super(String.format(ERROR, checksumType, expectedChecksum, actualChecksum));
    }

    @Override
    public int getErrorCode() {
        return 409;
    }

    @Override
    public String getMessage() {
        return "409 : " + super.getMessage();
    }

    @Override
    public String toString() {
        return "BinaryRejectedException: " + this.getMessage();
    }
}

