/*
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2016 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.storage.binstore.ifc;

import org.jfrog.storage.binstore.exceptions.BinaryStorageException;
import org.jfrog.storage.binstore.ifc.model.BinaryElement;
import org.jfrog.storage.binstore.ifc.model.BinaryProvidersInfo;
import org.jfrog.storage.binstore.ifc.provider.BinaryProvider;
import org.jfrog.storage.binstore.ifc.provider.ExternalWrapperBinaryProvider;

import javax.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

/**
 * @author gidis
 */
public interface BinaryProviderManager extends BinaryProviderManagerBase, ContextListener, ClusterChangesListener {

    String MANAGER_CONTEXT_KEY = "org.jfrog.storage.binstore.manager";
    String ACCESS_SERVICE_TYPE = "jf-binary-store";
    String SERVLET_CONTEXT_PATH = "binarystore";

    BinaryProvidersInfo<BinaryProviderInfo> getBinaryProvidersInfo();

    BinaryProvidersInfo<BinaryProviderInfo> getBinaryProvidersInfo(boolean useCache);

    boolean optimize(boolean force);

    void ping() throws BinaryStorageException;

    /**
     * Writes {@link BinaryElement} objects into the {@param outputStream} for each checksum that is contained in one
     * of this manager's child providers (all along the chain)
     *
     * @param subDir          Optional. If present the listing will be performed only under this subdir (one level down), if present.
     * @param requestHeaders  Optional. Allows passing request headers (conforming to {@see BinaryElementHeaders} to downstream providers.
     */
    void writeFileListToStream(@Nullable String subDir, @Nullable Map<String, String> requestHeaders, OutputStream outputStream) throws IOException;

    List<String> getErrors();

    ExternalWrapperBinaryProvider getExternalWrapperBinaryProvider(File externalDir);

    void initializeExternalBinaryProvider(String mode, String externalDir, String absolutePath, BinaryProviderConfig defaultValues);

    @Nullable
    BinaryProvider getNextCloudProvider();

}
