/*
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2016 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.storage.binstore.ifc;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author Gidi Shabat
 */
public class BinaryProviderConfig {

    private Map<String, String> params = Maps.newHashMap();
    private Map<String, String> properties = Maps.newHashMap();
    private String binaryStoreXmlPath;
    private BinaryStoreContext binaryStoreContext;

    public BinaryStoreContext getBinaryStoreContext() {
        return binaryStoreContext;
    }

    public void setBinaryStoreContext(BinaryStoreContext binaryStoreContext) {
        this.binaryStoreContext = binaryStoreContext;
    }

    public String getBinaryStoreXmlPath() {
        return binaryStoreXmlPath;
    }

    public void setBinaryStoreXmlPath(String binaryStoreXmlPath) {
        this.binaryStoreXmlPath = binaryStoreXmlPath;
    }

    public void addParam(String key, String value) {
        params.put(key, value);
    }

    public void addProperty(String key, String value) {
        properties.put(key, value);
    }

    public String getParam(String key) {
        return params.get(key);
    }

    public Map<String, String> getProperties() {
        Map<String, String> result = Maps.newHashMap();
        properties.keySet().forEach(key -> result.put(key, properties.get(key)));
        return result;
    }


}
