/*
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2016 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.storage.binstore.ifc.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Gidi Shabat
 */
public class BinaryTreeElement<T> implements Serializable {
    private T data;
    private BinaryTreeElement<T> nextBinaryTreeElement;
    private List<BinaryTreeElement<T>> subBinaryTreeElements = new ArrayList<>();

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public BinaryTreeElement<T> getNextBinaryTreeElement() {
        return nextBinaryTreeElement;
    }

    public void setNextBinaryTreeElement(BinaryTreeElement<T> next) {
        this.nextBinaryTreeElement = next;
    }

    public List<BinaryTreeElement<T>> getSubBinaryTreeElements() {
        return subBinaryTreeElements;
    }

    public void setSubBinaryTreeElements(List<BinaryTreeElement<T>> subBinaryTreeElements) {
        this.subBinaryTreeElements = subBinaryTreeElements;
    }
}
