/*
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2016 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.storage.binstore.exceptions;

/**
 * @author Fred Simon
 * @author Dan Feldman
 */
public class BinaryStorageException extends RuntimeException implements ResponseReadyException {

    private int code = 503;

    public BinaryStorageException(String message) {
        super(message);
    }

    public BinaryStorageException(String message, Throwable cause) {
        super(message, cause);
    }

    public BinaryStorageException(String message, Throwable cause, int code) {
        super(message, cause);
        this.code = code;
    }

    @Override
    public int getErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return code + " : " + super.getMessage();
    }

    @Override
    public String toString() {
        return "BinaryStorageException: " + getMessage();
    }
}
