/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.jfrog.security.ssl.CertificateGenerationException;
import org.jfrog.security.util.BCProviderFactory;

public class SignedCertificateBuilder {
    private X500Principal iss;
    private PrivateKey issPrivateKey;
    private X500Principal sub;
    private BigInteger serialNumber;
    private PublicKey subPublicKey;
    private Long expireIn;
    private int certVersion;
    private boolean useSubForSAN = false;
    private List<GeneralName> sanValues = new ArrayList<GeneralName>();
    private boolean isCA = false;
    private boolean isTLS = false;
    private static final String SIG_ALG = "SHA256WithRSA";
    private static final String BC_PROVIDER = "BC";
    public static final ASN1ObjectIdentifier CERT_VERSION_OID = new ASN1ObjectIdentifier("2.5.29.17.1").intern();
    private static final long ONE_DAY_IN_MS = 86400000L;
    private static final long MAX_EXPIRY;

    public static SignedCertificateBuilder builder() {
        return new SignedCertificateBuilder();
    }

    public SignedCertificateBuilder iss(String issuerCN) {
        this.iss = new X500Principal("CN=" + issuerCN);
        return this;
    }

    public SignedCertificateBuilder iss(X500Principal issuer) {
        this.iss = issuer;
        return this;
    }

    public SignedCertificateBuilder issPrivateKey(PrivateKey issPrivateKey) {
        this.issPrivateKey = issPrivateKey;
        return this;
    }

    public SignedCertificateBuilder sub(String subject) {
        this.sub = new X500Principal("CN=" + subject);
        return this;
    }

    public SignedCertificateBuilder sub(X500Principal subject) {
        this.sub = subject;
        return this;
    }

    public SignedCertificateBuilder serialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public SignedCertificateBuilder subPublicKey(PublicKey subPublicKey) {
        this.subPublicKey = subPublicKey;
        return this;
    }

    public SignedCertificateBuilder expireIn(Long expireIn) {
        this.expireIn = expireIn;
        return this;
    }

    public SignedCertificateBuilder certVersion(int certVersion) {
        this.certVersion = certVersion;
        return this;
    }

    public SignedCertificateBuilder isCA(boolean isCA) {
        this.isCA = isCA;
        return this;
    }

    public SignedCertificateBuilder isTLS(boolean isTLS) {
        this.isTLS = isTLS;
        return this;
    }

    public SignedCertificateBuilder sanValue(GeneralName generalName) {
        this.sanValues.add(generalName);
        return this;
    }

    public SignedCertificateBuilder sanIpOrDnsValue(String ip) {
        if (IPAddress.isValid((String)ip)) {
            this.sanValues.add(new GeneralName(7, ip));
        } else {
            this.sanValues.add(new GeneralName(2, ip));
        }
        return this;
    }

    public SignedCertificateBuilder useSubForSAN() {
        this.useSubForSAN = true;
        return this;
    }

    public Certificate build() throws CertificateGenerationException {
        X509Certificate x509Cert = this.buildX509Certificate();
        try {
            ByteArrayInputStream certStream = new ByteArrayInputStream(x509Cert.getEncoded());
            return CertificateFactory.getInstance("X509").generateCertificate(certStream);
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Failed to convert X509 certificate.", e);
        }
    }

    public X509Certificate buildX509Certificate() throws CertificateGenerationException {
        try {
            Date startDate = new Date(System.currentTimeMillis() - 86400000L);
            Date endDate = this.getEndDate(this.expireIn == null ? Long.MAX_VALUE : this.expireIn);
            X509v3CertificateBuilder builder = this.getX509v3CertificateBuilder(startDate, endDate);
            GeneralName[] sanContent = this.getSANContent();
            if (sanContent.length > 0) {
                builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(sanContent));
            }
            this.addCertificateVersion(builder, this.certVersion);
            return this.getSignedCertificate(this.issPrivateKey, builder);
        }
        catch (Exception e) {
            throw new CertificateGenerationException("Failed to generate signed certificate: " + e.getMessage(), e);
        }
    }

    private Date getEndDate(long expireIn) {
        if (expireIn < 0L) {
            throw new IllegalArgumentException("'expire in' must be a positive number");
        }
        long endMillis = System.currentTimeMillis() + expireIn;
        endMillis = endMillis < 0L || endMillis > MAX_EXPIRY ? MAX_EXPIRY : endMillis;
        return new Date(endMillis);
    }

    private X509v3CertificateBuilder getX509v3CertificateBuilder(Date startDate, Date endDate) throws IOException {
        X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(X500Name.getInstance((Object)this.iss.getEncoded()), this.serialNumber == null ? BigInteger.ONE : this.serialNumber, startDate, endDate, X500Name.getInstance((Object)this.sub.getEncoded()), SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(this.subPublicKey.getEncoded()).readObject()));
        if (this.isCA) {
            x509v3CertificateBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new X509KeyUsage(132)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        } else if (this.isTLS) {
            ASN1EncodableVector purposes = new ASN1EncodableVector();
            purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
            purposes.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
            x509v3CertificateBuilder.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new DERSequence(purposes)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new X509KeyUsage(160)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        }
        return x509v3CertificateBuilder;
    }

    private void addCertificateVersion(X509v3CertificateBuilder builder, int version) throws CertIOException {
        DERSequence seq = new DERSequence(new ASN1Encodable[]{CERT_VERSION_OID, new ASN1Integer((long)version)});
        ArrayList<GeneralName> namesList = new ArrayList<GeneralName>();
        namesList.add(new GeneralName(0, (ASN1Encodable)seq));
        GeneralNames versionName = GeneralNames.getInstance((Object)new DERSequence((ASN1Encodable[])namesList.toArray(new GeneralName[0])));
        builder.addExtension(CERT_VERSION_OID, false, (ASN1Encodable)versionName);
    }

    private GeneralName[] getSANContent() {
        if (this.useSubForSAN) {
            X500Name x500Name = X500Name.getInstance((Object)this.sub.getEncoded());
            ASN1Encodable firstValue = x500Name.getRDNs()[0].getFirst().getValue();
            String name = IETFUtils.valueToString((ASN1Encodable)firstValue);
            this.sanValues.add(new GeneralName(2, name));
        }
        if (!this.sanValues.isEmpty()) {
            return this.sanValues.toArray(new GeneralName[0]);
        }
        return new GeneralName[0];
    }

    private X509Certificate getSignedCertificate(PrivateKey issuerPrivateKey, X509v3CertificateBuilder builder) throws OperatorCreationException, CertificateException, IOException {
        ContentSigner sigGen = new JcaContentSignerBuilder(SIG_ALG).setProvider(BC_PROVIDER).build(issuerPrivateKey);
        X509CertificateHolder certHolder = builder.build(sigGen);
        try (ByteArrayInputStream is = new ByteArrayInputStream(certHolder.getEncoded());){
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
            return x509Certificate;
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7000, 0, 1, 0, 0);
        MAX_EXPIRY = calendar.getTimeInMillis();
        BCProviderFactory.getProvider();
    }
}

