/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.jfrog.security.ssl.CertificateGenerationException;
import org.jfrog.security.ssl.SignedCertificateBuilder;
import org.jfrog.security.util.BCProviderFactory;

public abstract class CertificateHelper {
    public static final ASN1ObjectIdentifier CERT_VERSION_OID = new ASN1ObjectIdentifier("2.5.29.17.1").intern();

    private CertificateHelper() {
    }

    public static int getCertificateVersion(X509Certificate certificate) throws IOException {
        byte[] version = certificate.getExtensionValue(CERT_VERSION_OID.getId());
        if (version != null) {
            GeneralName[] names;
            Integer versionFromCertificate = null;
            GeneralNames gn = GeneralNames.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])version));
            for (GeneralName name : names = gn.getNames()) {
                if (name.getTagNo() != 0) continue;
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)name.getName());
                ASN1Integer value = (ASN1Integer)seq.getObjectAt(1);
                versionFromCertificate = value.getValue().intValue();
            }
            return versionFromCertificate;
        }
        return 0;
    }

    public static X509Certificate generateRootCertificate(KeyPair keyPair, String commonName, int certVersion) throws CertificateGenerationException {
        BigInteger serialNumber = CertificateHelper.randomSerialNumber();
        return SignedCertificateBuilder.builder().iss(commonName).issPrivateKey(keyPair.getPrivate()).sub(commonName).subPublicKey(keyPair.getPublic()).serialNumber(serialNumber).expireIn(Long.MAX_VALUE).certVersion(certVersion).useSubForSAN().isCA(true).buildX509Certificate();
    }

    public static BigInteger randomSerialNumber() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return new BigInteger(1, bb.array());
    }

    public static String getCertificateIssuerCommonName(X509Certificate certificate) throws CertificateEncodingException {
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getIssuer().getRDNs(BCStyle.CN);
        return CertificateHelper.getName(result, rdNs);
    }

    public static String getCertificateSubjectAlternativeName(X509Certificate certificate) throws CertificateEncodingException {
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        Extensions extensions = certificateHolder.getExtensions();
        GeneralNames generalNames = GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
        if (generalNames == null) {
            return "";
        }
        GeneralName[] names = generalNames.getNames();
        if (names == null || names.length == 0) {
            return "";
        }
        GeneralName generalName = names[0];
        return generalName.getName().toString();
    }

    public static String getCertificateSubjectCommonName(X509Certificate certificate) throws CertificateEncodingException {
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getSubject().getRDNs(BCStyle.CN);
        return CertificateHelper.getName(result, rdNs);
    }

    public static Date getIssuedAt(X509Certificate certificate) {
        return certificate.getNotBefore();
    }

    public static String getCertificateIssuerOrganizationUnit(X509Certificate certificate) throws CertificateEncodingException {
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getIssuer().getRDNs(BCStyle.OU);
        return CertificateHelper.getName(result, rdNs);
    }

    public static String getCertificateIssuerOrganization(X509Certificate certificate) throws CertificateEncodingException {
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getIssuer().getRDNs(BCStyle.O);
        return CertificateHelper.getName(result, rdNs);
    }

    public static String getCertificateSubjectOrganizationUnit(X509Certificate certificate) throws CertificateEncodingException {
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getSubject().getRDNs(BCStyle.OU);
        return CertificateHelper.getName(result, rdNs);
    }

    public static String getCertificateSubjectOrganization(X509Certificate certificate) throws CertificateEncodingException {
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getSubject().getRDNs(BCStyle.O);
        return CertificateHelper.getName(result, rdNs);
    }

    public static Date getValidUntil(X509Certificate certificate) {
        return certificate.getNotAfter();
    }

    public static String getCertificateFingerprint(X509Certificate certificate) throws CertificateEncodingException {
        byte[] bytes = DigestUtils.sha256((byte[])certificate.getEncoded());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String appendString = Integer.toHexString(0xFF & bytes[i]);
            if (appendString.length() == 1) {
                builder.append("0");
            }
            builder.append(appendString.toUpperCase());
            if (i == bytes.length - 1) continue;
            builder.append(':');
        }
        return builder.toString();
    }

    private static String getName(String result, RDN[] rdNs) {
        RDN firstRDN;
        if (rdNs != null && rdNs.length > 0 && (firstRDN = rdNs[0]).getFirst() != null && firstRDN.getFirst().getValue() != null) {
            result = IETFUtils.valueToString((ASN1Encodable)firstRDN.getFirst().getValue());
        }
        return result;
    }

    static {
        BCProviderFactory.getProvider();
    }

    public static class CryptoInfo {
        private KeyPair keyPair;
        private X509Certificate certificate;

        public CryptoInfo(KeyPair keyPair, X509Certificate certificate) {
            this.keyPair = keyPair;
            this.certificate = certificate;
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        public void setKeyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public void setCertificate(X509Certificate certificate) {
            this.certificate = certificate;
        }
    }
}

