/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto.signing.rsa;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RSASigner {
    private static final Logger log = LoggerFactory.getLogger(RSASigner.class);

    public static byte[] signDataWithSha1(byte[] dataToSign, PrivateKey privateKey) throws Exception {
        log.debug("Signing data");
        AsymmetricKeyParameter privateKeyAsymKeyParam = PrivateKeyFactory.createKey((byte[])privateKey.getEncoded());
        RSADigestSigner signer = new RSADigestSigner((Digest)new SHA1Digest());
        signer.init(true, (CipherParameters)privateKeyAsymKeyParam);
        signer.update(dataToSign, 0, dataToSign.length);
        try {
            return signer.generateSignature();
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot generate RSA signature. " + ex.getMessage(), ex);
        }
    }

    public static void verifySha1Signature(byte[] signature, byte[] signedData, PublicKey publicKey) throws IOException {
        log.debug("Verifying Signature");
        AsymmetricKeyParameter publicKeyParameter = PublicKeyFactory.createKey((byte[])publicKey.getEncoded());
        RSADigestSigner signer = new RSADigestSigner((Digest)new SHA1Digest());
        signer.init(false, (CipherParameters)publicKeyParameter);
        signer.update(signedData, 0, signedData.length);
        if (!signer.verifySignature(signature)) {
            throw new IllegalArgumentException("The sign cannot be verified with the given public key");
        }
    }

    private RSASigner() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

