/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto.signing.gpg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.jfrog.security.crypto.exception.CryptoRuntimeException;
import org.jfrog.security.crypto.signing.gpg.WrappedPrivateKey;
import org.jfrog.security.util.BCProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGPKeyParser {
    private static final Logger log = LoggerFactory.getLogger(PGPKeyParser.class);
    private static Map<String, String> curveToJwsAlgoNameConverter = new HashMap<String, String>();

    public static WrappedPrivateKey privateKeyParse(byte[] privateKey, String passphrase) {
        try {
            PGPSecretKey pgpSec = PGPKeyParser.findSecretGPGKey(privateKey);
            PGPPublicKey pgpPublicKey = pgpSec.getPublicKey();
            String kid = PGPKeyParser.calculateKeyId(pgpPublicKey);
            PBESecretKeyDecryptor decryptor = new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)BCProviderFactory.getProvider()).build(passphrase.toCharArray());
            PGPPrivateKey pgpPriv = pgpSec.extractPrivateKey(decryptor);
            String algName = PGPKeyParser.getAlgorithmFromKey(pgpPriv);
            JcaPGPKeyConverter converter = new JcaPGPKeyConverter();
            BouncyCastleProvider bcProvider = BCProviderFactory.getProvider();
            converter.setProvider((Provider)bcProvider);
            PrivateKey privateKeyObj = converter.getPrivateKey(pgpPriv);
            return new WrappedPrivateKey(privateKeyObj, kid, algName);
        }
        catch (Exception e) {
            log.error("Error Parsing GPG Private Key " + e.getMessage());
            throw new CryptoRuntimeException(e);
        }
    }

    public static String calculateKeyId(PGPPublicKey pgpPublicKey) throws IOException {
        return DigestUtils.sha256Hex((byte[])pgpPublicKey.getEncoded()).substring(0, 6);
    }

    public static PGPPublicKey pgpPublicKeyParse(byte[] publicKeyBytes) {
        try {
            InputStream pgpIn = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(publicKeyBytes));
            PGPObjectFactory pgpFact = new PGPObjectFactory(pgpIn, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            PGPPublicKeyRing pgpSecRing = (PGPPublicKeyRing)pgpFact.nextObject();
            return pgpSecRing.getPublicKey();
        }
        catch (IOException e) {
            log.error("Error Parsing GPG Public Key " + e.getMessage());
            throw new CryptoRuntimeException(e);
        }
    }

    public static PublicKey publicKeyParse(byte[] publicKeyBytes) {
        try {
            PGPPublicKey publicKey = PGPKeyParser.pgpPublicKeyParse(publicKeyBytes);
            JcaPGPKeyConverter converter = new JcaPGPKeyConverter();
            BouncyCastleProvider bcProvider = BCProviderFactory.getProvider();
            converter.setProvider((Provider)bcProvider);
            return converter.getPublicKey(publicKey);
        }
        catch (Exception e) {
            log.error("Error Parsing GPG Public Key " + e.getMessage());
            throw new CryptoRuntimeException(e);
        }
    }

    public static PGPSecretKey findSecretGPGKey(byte[] privateKey) {
        try {
            InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(privateKey));
            BcKeyFingerprintCalculator keyFingerPrintCalculator = new BcKeyFingerprintCalculator();
            PGPSecretKeyRingCollection secretKeyRings = new PGPSecretKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)keyFingerPrintCalculator);
            Iterator privateKeys = secretKeyRings.getKeyRings();
            if (privateKeys.hasNext()) {
                return ((PGPSecretKeyRing)privateKeys.next()).getSecretKey();
            }
            throw new PGPException("No private key found!");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new CryptoRuntimeException(e);
        }
    }

    public static String getAlgorithmFromKey(PGPPrivateKey privKey) {
        PublicKeyPacket pubPk = privKey.getPublicKeyPacket();
        switch (pubPk.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                return "RSA";
            }
            case 19: {
                String convertedVal;
                ECDSAPublicBCPGKey ecdsaPub = (ECDSAPublicBCPGKey)pubPk.getKey();
                String curveName = NISTNamedCurves.getName((ASN1ObjectIdentifier)ecdsaPub.getCurveOID());
                if (StringUtils.isBlank((CharSequence)curveName)) {
                    curveName = ECNamedCurveTable.getName((ASN1ObjectIdentifier)ecdsaPub.getCurveOID());
                }
                return (convertedVal = curveToJwsAlgoNameConverter.get(curveName)) == null ? curveName : convertedVal;
            }
        }
        return null;
    }

    static {
        curveToJwsAlgoNameConverter.put("P-256", "ES256");
        curveToJwsAlgoNameConverter.put("P-384", "ES384");
        curveToJwsAlgoNameConverter.put("P-521", "ES512");
    }
}

