/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto.encoder;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class EncryptedString {
    private final String keyId;
    private final String alg;
    private final byte[] cipherText;

    public EncryptedString(String keyId, String alg, byte[] cipherText) {
        this.assertNonEmpty(keyId, alg, cipherText);
        this.keyId = keyId.toLowerCase();
        this.alg = alg.toLowerCase();
        this.cipherText = cipherText;
    }

    public static EncryptedString parse(String encryptedString) {
        if (!EncryptedString.isEncodedByMe(encryptedString)) {
            throw new IllegalArgumentException("Input string is not encoded correctly");
        }
        String[] parts = encryptedString.split("\\.");
        return new EncryptedString(parts[0], parts[1], Base64.decodeBase64((String)parts[2]));
    }

    public String encode() {
        return this.keyId + "." + this.alg + "." + Base64.encodeBase64URLSafeString((byte[])this.cipherText);
    }

    public static boolean isEncodedByMe(String encryptedString) {
        if (StringUtils.isBlank((CharSequence)encryptedString)) {
            return false;
        }
        String[] parts = encryptedString.split("\\.");
        if (parts.length != 3) {
            return false;
        }
        return EncryptedString.verifyKeyId(parts[0]) && EncryptedString.verifyAlg(parts[1]) && EncryptedString.verifyCipherText(parts[2]);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getAlg() {
        return this.alg;
    }

    public byte[] getCipherText() {
        return this.cipherText;
    }

    private void assertNonEmpty(String keyId, String alg, byte[] payload) {
        if (StringUtils.isBlank((CharSequence)keyId)) {
            throw new IllegalArgumentException("key id cannot be empty");
        }
        if (StringUtils.isBlank((CharSequence)alg)) {
            throw new IllegalArgumentException("alg cannot be empty");
        }
        if (payload == null || payload.length == 0) {
            throw new IllegalArgumentException("payload cannot be empty");
        }
    }

    private static boolean verifyKeyId(String keyId) {
        return keyId.length() == 6;
    }

    private static boolean verifyAlg(String alg) {
        return "aesgcm128".equalsIgnoreCase(alg) || "aesgcm256".equalsIgnoreCase(alg);
    }

    private static boolean verifyCipherText(String cipherText) {
        return !StringUtils.isBlank((CharSequence)cipherText) && Base64.isBase64((String)cipherText);
    }
}

