/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.jfrog.security.crypto.exception.CryptoRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JFrogBase58 {
    private static final Logger log;
    private static final char[] ALPHABET;
    static Set<Character> alphabetSet;
    private static final int BASE_58;
    private static final int BASE_256 = 256;
    private static final int[] INDEXES;
    private static final byte[] EMPTY_STRING_CODE;

    private static Set<Character> toCharSet(char[] arr) {
        HashSet<Character> res = new HashSet<Character>();
        for (char c : arr) {
            res.add(Character.valueOf(c));
        }
        return Collections.unmodifiableSet(res);
    }

    static byte[] extractBytes(String input) {
        int offset = 2;
        byte[] inputWithChk = JFrogBase58.decode(input, offset);
        byte[] res = JFrogBase58.removeCheckSum(inputWithChk);
        if (res == null) {
            log.warn("Received input string '" + JFrogCryptoHelper.debugMessageForSensitiveStrings(input) + "' with wrong checksum of last 2 bytes");
            return null;
        }
        return res;
    }

    static byte[] removeCheckSum(byte[] inputWithChk) {
        boolean good = JFrogBase58.isGoodChecksum(inputWithChk);
        if (!good) {
            return null;
        }
        return JFrogBase58.copyOfRange(inputWithChk, 0, inputWithChk.length - 2);
    }

    static boolean isGoodChecksum(byte[] inputWithChk) {
        MessageDigest digest = JFrogBase58.getSha256MessageDigest();
        digest.update(inputWithChk, 0, inputWithChk.length - 2);
        byte[] doubleDigest = digest.digest(digest.digest());
        return doubleDigest[0] == inputWithChk[inputWithChk.length - 2] && doubleDigest[1] == inputWithChk[inputWithChk.length - 1];
    }

    static byte[] bytesToEncode(byte[] toEncode) {
        byte[] bytes;
        if (toEncode == null || toEncode.length == 0) {
            JFrogBase58.checkEmptyString();
            bytes = EMPTY_STRING_CODE;
        } else {
            MessageDigest digest = JFrogBase58.getSha256MessageDigest();
            byte[] doubleDigest = digest.digest(digest.digest(toEncode));
            bytes = new byte[toEncode.length + 2];
            System.arraycopy(toEncode, 0, bytes, 0, toEncode.length);
            bytes[bytes.length - 2] = doubleDigest[0];
            bytes[bytes.length - 1] = doubleDigest[1];
        }
        return bytes;
    }

    private static void checkEmptyString() {
        if (EMPTY_STRING_CODE[0] == 0) {
            MessageDigest digest = JFrogBase58.getSha256MessageDigest();
            byte[] doubleDigest = digest.digest(digest.digest(new byte[0]));
            JFrogBase58.EMPTY_STRING_CODE[0] = doubleDigest[0];
            JFrogBase58.EMPTY_STRING_CODE[1] = doubleDigest[1];
        }
    }

    public static MessageDigest getSha256MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    @Deprecated
    public static boolean isBase58(String input) {
        char[] chars;
        for (char c : chars = input.toCharArray()) {
            boolean inAlphabet = false;
            for (char c1 : ALPHABET) {
                if (c1 != c) continue;
                inAlphabet = true;
                break;
            }
            if (inAlphabet) continue;
            return false;
        }
        return true;
    }

    public static String encode(byte[] input) {
        int zeroCount;
        if (input.length == 0) {
            return "";
        }
        input = JFrogBase58.copyOfRange(input, 0, input.length);
        for (zeroCount = 0; zeroCount < input.length && input[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length * 2];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input.length) {
            byte mod = JFrogBase58.divmod58(input, startAt);
            if (input[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = (byte)ALPHABET[mod];
        }
        while (j < temp.length && temp[j] == ALPHABET[0]) {
            ++j;
        }
        while (--zeroCount >= 0) {
            temp[--j] = (byte)ALPHABET[0];
        }
        byte[] output = JFrogBase58.copyOfRange(temp, j, temp.length);
        return new String(output);
    }

    public static byte[] decode(String input) {
        int offset = 0;
        return JFrogBase58.decode(input, offset);
    }

    static byte[] decode(String input, int offset) {
        int zeroCount;
        if (input.length() == offset) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length() - offset];
        for (int i = 0; i < input58.length; ++i) {
            char c = input.charAt(offset + i);
            int digit58 = -1;
            if (c < '\u0080') {
                digit58 = INDEXES[c];
            }
            if (digit58 < 0) {
                throw new RuntimeException("Not a JFrogBase58 input: " + input);
            }
            input58[i] = (byte)digit58;
        }
        for (zeroCount = 0; zeroCount < input58.length && input58[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input58.length];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input58.length) {
            byte mod = JFrogBase58.divmod256(input58, startAt);
            if (input58[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = mod;
        }
        while (j < temp.length && temp[j] == 0) {
            ++j;
        }
        return JFrogBase58.copyOfRange(temp, j - zeroCount, temp.length);
    }

    private static byte divmod58(byte[] number, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number.length; ++i) {
            int digit256 = number[i] & 0xFF;
            int temp = remainder * 256 + digit256;
            number[i] = (byte)(temp / BASE_58);
            remainder = temp % BASE_58;
        }
        return (byte)remainder;
    }

    private static byte divmod256(byte[] number58, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number58.length; ++i) {
            int digit58 = number58[i] & 0xFF;
            int temp = remainder * BASE_58 + digit58;
            number58[i] = (byte)(temp / 256);
            remainder = temp % 256;
        }
        return (byte)remainder;
    }

    private static byte[] copyOfRange(byte[] source, int from, int to) {
        byte[] range = new byte[to - from];
        System.arraycopy(source, from, range, 0, range.length);
        return range;
    }

    static {
        int i;
        log = LoggerFactory.getLogger(JFrogBase58.class);
        ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
        alphabetSet = JFrogBase58.toCharSet(ALPHABET);
        BASE_58 = ALPHABET.length;
        INDEXES = new int[128];
        EMPTY_STRING_CODE = new byte[2];
        for (i = 0; i < INDEXES.length; ++i) {
            JFrogBase58.INDEXES[i] = -1;
        }
        for (i = 0; i < ALPHABET.length; ++i) {
            JFrogBase58.INDEXES[JFrogBase58.ALPHABET[i]] = i;
        }
    }
}

