/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.EncodingType;
import org.jfrog.security.crypto.EncryptionWrapper;
import org.jfrog.security.crypto.FormatUsed;
import org.jfrog.security.crypto.JFrogEnvelop;
import org.jfrog.security.crypto.KeyIdAlgCipherNotFound;
import org.jfrog.security.crypto.SecretProvider;
import org.jfrog.security.crypto.encrypter.BytesEncrypterBase;
import org.jfrog.security.crypto.encrypter.DummyBytesEncrypter;
import org.jfrog.security.crypto.exception.CryptoRuntimeException;
import org.jfrog.security.crypto.result.DecryptionBytesResult;
import org.jfrog.security.crypto.result.DecryptionStatus;
import org.jfrog.security.crypto.result.DecryptionStringResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EncryptionWrapperBase
implements EncryptionWrapper,
SecretProvider {
    private final List<BytesEncrypterBase> decrypters;
    final BytesEncrypterBase topEncrypter;
    private static final Logger log = LoggerFactory.getLogger(EncryptionWrapperBase.class);
    @Nonnull
    private final EncodingType encodingType;
    private final FormatUsed formatUsed;

    public EncryptionWrapperBase(@Nonnull EncodingType targetEncodingType, BytesEncrypterBase encrypter, List<BytesEncrypterBase> decrypters, FormatUsed formatUsed) {
        if (targetEncodingType == EncodingType.NO_ENCODING && !(encrypter instanceof DummyBytesEncrypter)) {
            throw new IllegalArgumentException("Symmetric encryption cannot use a no encoder for byte to string");
        }
        this.topEncrypter = encrypter;
        this.formatUsed = formatUsed;
        if (decrypters == null) {
            decrypters = new ArrayList<BytesEncrypterBase>();
        }
        this.decrypters = decrypters;
        this.encodingType = targetEncodingType;
    }

    @Override
    public CipherAlg getCipherAlg() {
        return this.topEncrypter.getCipherAlg();
    }

    @Override
    @Nonnull
    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    @Override
    public boolean isEncodedByMe(String in) {
        return in != null && this.getEncodingType().isEncodedByMe(in);
    }

    @Override
    @Nonnull
    public DecryptionStringResult decryptIfNeeded(String in) {
        if (in == null) {
            return new DecryptionStringResult(null);
        }
        JFrogEnvelop envelop = JFrogEnvelop.parse(in);
        if (!(envelop == null || envelop.encodingType.isEncryptedFormat() && envelop.isGoodChecksum())) {
            return new DecryptionStringResult(in);
        }
        if (!this.isEncodedByMe(in)) {
            return new DecryptionStringResult(in);
        }
        return this.decrypt(in);
    }

    private DecryptionStringResult decrypt(String in) {
        JFrogEnvelop envelop = JFrogEnvelop.parse(in);
        if (envelop == null) {
            throw new RuntimeException("Can't parse encrypted");
        }
        DecryptionBytesResult res = this.decrypt(envelop);
        return new DecryptionStringResult(EncodingType.bytesToString(res.getDecryptedData()), res.getStatus());
    }

    public DecryptionBytesResult decrypt(@Nonnull byte[] bytes) {
        return this.decrypt(null, null, bytes);
    }

    private DecryptionBytesResult decrypt(JFrogEnvelop envelop) {
        CipherAlg alg = envelop.getAlg();
        String keyId = envelop.getKeyId();
        byte[] bytes = envelop.extractBytes();
        return this.decrypt(keyId, alg, bytes);
    }

    private DecryptionBytesResult decrypt(String keyId, CipherAlg alg, byte[] bytes) {
        Exception firstException = null;
        if (this.isUnspecifiedOrMatchedWithTop(keyId, alg)) {
            try {
                return new DecryptionBytesResult(this.topEncrypter.decrypt(bytes), DecryptionStatus.SUCCESS);
            }
            catch (Exception e) {
                firstException = e;
            }
        }
        return this.decryptFallback(keyId, alg, bytes, firstException);
    }

    private DecryptionBytesResult decryptFallback(@Nullable String keyId, @Nullable CipherAlg alg, @Nonnull byte[] bytes, @Nullable Exception firstException) {
        Stream<Object> filtered = this.decrypters.stream();
        if (alg != null) {
            filtered = filtered.filter(it -> it.getCipherAlg() == alg);
        }
        if (keyId != null) {
            filtered = filtered.filter(it -> it.keyMatch(keyId));
        }
        Iterator iter = filtered.iterator();
        while (iter.hasNext()) {
            BytesEncrypterBase it2 = (BytesEncrypterBase)iter.next();
            try {
                byte[] decrypted = it2.decrypt(bytes);
                return new DecryptionBytesResult(decrypted, DecryptionStatus.SUCCESS_WITH_FALLBACK);
            }
            catch (Exception ex) {
                if (keyId != null) {
                    if (firstException == null) {
                        log.error("Failed decrypt with matching keyId {} alg {} ", new Object[]{keyId, alg, ex});
                        firstException = ex;
                        continue;
                    }
                    log.debug("Again - Failed decrypt with matching keyId {} alg {} ", new Object[]{keyId, alg, ex});
                    continue;
                }
                if (firstException == null) {
                    firstException = ex;
                }
                log.trace("Failed decrypt (unspecified keyId) {} alg {} ", new Object[]{it2.getKeyId(), alg, ex});
            }
        }
        if (firstException == null) {
            if (keyId != null) {
                log.error("no matched algorithm and key for {} {}", (Object)alg, (Object)keyId);
                firstException = new CryptoRuntimeException(new KeyIdAlgCipherNotFound("no matched algorithm and key for" + alg + " " + keyId));
            } else {
                String msg = String.format("Unexpected decrypt without keyId and no matchig alg %s", new Object[]{alg});
                log.error(msg);
                throw new CryptoRuntimeException(msg);
            }
        }
        throw new CryptoRuntimeException(firstException.getCause());
    }

    @Override
    @Nullable
    public byte[] encrypt(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.topEncrypter.encrypt(bytes);
    }

    @Override
    @Nonnull
    public String getFingerprint() {
        return this.topEncrypter.getFingerprint();
    }

    @Deprecated
    String encryptIfNeededNoMigrate(String in) {
        if (in == null) {
            return null;
        }
        if (this.isEncodedByMe(in)) {
            return in;
        }
        byte[] bytes = this.topEncrypter.encrypt(EncodingType.stringToBytes(in));
        return this.getEncodingType().encodeFormat(this.topEncrypter.getKeyId(), this.topEncrypter.getCipherAlg(), bytes);
    }

    @Override
    public String encryptIfNeeded(String in) {
        if (in == null) {
            return null;
        }
        if (!this.encodingType.isEncryptedFormat()) {
            throw new RuntimeException("Encrypting with plaintext encoding " + this.encodingType);
        }
        JFrogEnvelop envelop = JFrogEnvelop.parse(in);
        if (envelop != null && this.isTopEncrypted(envelop)) {
            return in;
        }
        String plain = this.decryptIfNeeded(in).getDecryptedData();
        if (plain == null || this.isEncodedByMe(in) && !plain.equals(in)) {
            return in;
        }
        byte[] bytes = this.topEncrypter.encrypt(EncodingType.stringToBytes(plain));
        if (this.formatUsed == FormatUsed.OldFormat) {
            return this.getEncodingType().encode(bytes);
        }
        return this.getEncodingType().encodeFormat(this.topEncrypter.getKeyId(), this.topEncrypter.getCipherAlg(), bytes);
    }

    private boolean isUnspecifiedOrMatchedWithTop(String keyId, CipherAlg alg) {
        return this.isKeyUnspecifiedOrMatchedTop(keyId) && this.isAlgUnspecifiedOrMatched(alg);
    }

    private boolean isKeyUnspecifiedOrMatchedTop(String keyId) {
        return keyId == null || this.topEncrypter.keyMatch(keyId);
    }

    private boolean isAlgUnspecifiedOrMatched(CipherAlg alg) {
        return alg == null || alg.equals((Object)this.topEncrypter.getCipherAlg());
    }

    private boolean isTopEncrypted(JFrogEnvelop envelop) {
        if (envelop.encodingType != this.encodingType) {
            return false;
        }
        String keyId = envelop.getKeyId();
        if (keyId != null) {
            return this.topEncrypter.keyMatch(keyId);
        }
        return false;
    }

    void ensureMatchingPrivatePublicKeys() {
        EncryptionWrapperBase.ensureMatchingPrivatePublicKeys(this.topEncrypter);
    }

    private static void ensureMatchingPrivatePublicKeys(BytesEncrypterBase topEncrypter) {
        try {
            byte[] originalBytes = "Some text to encrypt".getBytes();
            byte[] encryptedBytes = topEncrypter.encrypt(originalBytes);
            byte[] decryptedBytes = topEncrypter.decrypt(encryptedBytes);
            if (!Arrays.equals(originalBytes, decryptedBytes)) {
                throw new IllegalStateException("Decrypted bytes are not equal to the original bytes.");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Provided private key and certificate do not match.", e);
        }
    }

    @Override
    public SecretKey getSecret() {
        return ((SecretProvider)((Object)this.topEncrypter)).getSecret();
    }

    public String toString() {
        return "EncryptionWrapperBase{ encodingType=" + this.encodingType + ", topEncrypter=" + this.topEncrypter + ", formatUsed=" + this.formatUsed + ", decrypters=" + this.decrypters + "}";
    }
}

