/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import java.security.KeyPair;
import java.security.PublicKey;
import org.jfrog.security.crypto.JFrogCryptoHelper;

public class DecodedKeyPair {
    final byte[] privateKey;
    final byte[] publicKey;

    public DecodedKeyPair(byte[] privateKey, byte[] publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public DecodedKeyPair(KeyPair keyPair) {
        this.privateKey = keyPair.getPrivate().getEncoded();
        this.publicKey = keyPair.getPublic().getEncoded();
    }

    public boolean hasPrivateKey() {
        return this.privateKey != null && this.privateKey.length > 0;
    }

    public KeyPair createKeyPair() {
        return JFrogCryptoHelper.convertToKeyPair(this.privateKey, this.publicKey);
    }

    public PublicKey createPublicKey() {
        return JFrogCryptoHelper.convertToPublicKey(this.publicKey);
    }
}

