/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.jfrog.security.crypto.encrypter.BytesEncrypterBase;

class AsymKeyBytesEncrypter
extends BytesEncrypterBase {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public AsymKeyBytesEncrypter(PublicKey publicKey, PrivateKey privateKey) {
        super(privateKey.getEncoded());
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    @Override
    public CipherAlg getCipherAlg() {
        return CipherAlg.RSA;
    }

    @Override
    @Nonnull
    public byte[] encrypt(@Nonnull byte[] bytes) {
        return JFrogCryptoHelper.encryptAsymmetric(bytes, this.publicKey);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        if (this.privateKey == null) {
            throw new IllegalStateException("Cannot decrypt without private key! This wrapper can only only encrypt!");
        }
        return JFrogCryptoHelper.decryptAsymmetric(bytes, this.privateKey);
    }
}

