/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.jfrog.security.crypto.EncryptionWrapper;
import org.jfrog.security.crypto.EncryptionWrapperFactory;
import org.jfrog.security.crypto.SecretProvider;
import org.jfrog.security.file.SecurityFolderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtils {
    private static final Logger log = LoggerFactory.getLogger(KeyUtils.class);
    private static final int LOG_PRINT_INTERVAL_SECONDS = 5;

    public static void saveKeyToFile(File keyFile, EncryptionWrapper keyWrapper) {
        boolean created;
        if (!keyFile.getParentFile().exists() && !(created = keyFile.getParentFile().mkdirs())) {
            log.warn("Unable to create directory {}!", (Object)keyFile.getParentFile().getPath());
        }
        try {
            SecretKey secretKey = ((SecretProvider)((Object)keyWrapper)).getSecret();
            byte[] keyBytes = secretKey.getEncoded();
            byte[] encodedBytes = Hex.encode((byte[])keyBytes);
            Path keyPath = Files.write(keyFile.toPath(), encodedBytes, new OpenOption[0]);
            SecurityFolderHelper.setPermissionsOnSecurityFile(keyPath, SecurityFolderHelper.PERMISSIONS_MODE_600);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not save key " + keyFile.getName(), e);
        }
    }

    public static String readKeyFromFile(File joinKeyFile) throws IOException {
        return StringUtils.trim((String)FileUtils.readFileToString((File)joinKeyFile));
    }

    public static void initKey(File keyFile, String key) {
        EncryptionWrapper keyWrapper = EncryptionWrapperFactory.aesKeyWrapperFromString(key);
        KeyUtils.saveKeyToFile(keyFile, keyWrapper);
    }

    public static void waitForKey(String keyName, long timeoutMillis, File keyFile) {
        KeyUtils.waitUntilKeyIsAvailable(keyName, timeoutMillis, keyFile::exists, 1);
        if (!keyFile.exists()) {
            throw KeyUtils.keyResolutionFailure(keyName, null);
        }
        KeyUtils.resolvedSuccessfullyLog(keyName);
    }

    public static String waitForKey(String keyName, long timeoutMillis, Supplier<Optional<String>> keyRetriever) {
        KeyUtils.waitUntilKeyIsAvailable(keyName, timeoutMillis, () -> ((Optional)keyRetriever.get()).isPresent(), 1);
        Optional<String> key = keyRetriever.get();
        if (key.isPresent()) {
            KeyUtils.validateKey(keyName, key.get());
            KeyUtils.resolvedSuccessfullyLog(keyName);
            return key.get();
        }
        throw KeyUtils.keyResolutionFailure(keyName, null);
    }

    public static void validateHexEncoding(String joinKey) throws DecoderException {
        org.apache.commons.codec.binary.Hex.decodeHex((char[])joinKey.toCharArray());
    }

    static boolean waitUntilKeyIsAvailable(String keyName, long timeoutMillis, BooleanSupplier keyExistenceSupplier, int existenceCheckDelaySecs) {
        long startTime;
        long now = startTime = System.currentTimeMillis();
        long lastWaitingLogEntryTime = 0L;
        if (log.isDebugEnabled()) {
            log.debug("{}Resolving {} key with {} seconds timeout", new Object[]{KeyUtils.getPrefixForLogs(keyName), keyName, TimeUnit.MILLISECONDS.toSeconds(timeoutMillis)});
        }
        while (!keyExistenceSupplier.getAsBoolean() && now - startTime < timeoutMillis) {
            long secondsPending = TimeUnit.MILLISECONDS.toSeconds(now - lastWaitingLogEntryTime);
            if (secondsPending >= 5L) {
                if (lastWaitingLogEntryTime > 0L && log.isInfoEnabled()) {
                    log.info("{}{} key is missing. Pending for {} seconds with {} seconds timeout", new Object[]{KeyUtils.getPrefixForLogs(keyName), StringUtils.capitalize((String)keyName), secondsPending, TimeUnit.MILLISECONDS.toSeconds(timeoutMillis)});
                }
                lastWaitingLogEntryTime = now;
            }
            KeyUtils.sleep(existenceCheckDelaySecs, keyName);
            now = System.currentTimeMillis();
        }
        return keyExistenceSupplier.getAsBoolean();
    }

    public static void sleep(long secToSleep, String keyName) {
        try {
            Thread.sleep(secToSleep * 1000L);
        }
        catch (InterruptedException e) {
            log.warn("{}Sleep interrupted while waiting for {} key", (Object)KeyUtils.getPrefixForLogs(keyName), (Object)keyName);
            log.debug("", (Throwable)e);
        }
    }

    private static void validateKey(String keyName, String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw KeyUtils.keyResolutionFailure(keyName, new IllegalStateException("Corrupted " + keyName + " key: Empty " + keyName + " key"));
        }
        try {
            KeyUtils.validateHexEncoding(key);
        }
        catch (DecoderException e) {
            throw KeyUtils.keyResolutionFailure(keyName, new IllegalStateException("Corrupted " + keyName + " key: key must be hex encoded"));
        }
    }

    private static void resolvedSuccessfullyLog(String keyName) {
        if (log.isDebugEnabled()) {
            log.debug("{}{} key resolved successfully", (Object)KeyUtils.getPrefixForLogs(keyName), (Object)StringUtils.capitalize((String)keyName));
        }
    }

    private static IllegalStateException keyResolutionFailure(String keyName, @Nullable Throwable exception) {
        IllegalStateException toThrow;
        if (exception == null) {
            toThrow = new IllegalStateException(KeyUtils.getPrefixForLogs(keyName) + "Failed resolving " + keyName + " key; Missing " + keyName + " key");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("", exception);
            }
            String errorMessage = String.format("%sFailed resolving %s key; %s", KeyUtils.getPrefixForLogs(keyName), keyName, exception.getMessage());
            log.error(errorMessage);
            toThrow = new IllegalStateException(errorMessage);
        }
        return toThrow;
    }

    private static String getPrefixForLogs(String keyName) {
        return keyName.equalsIgnoreCase("join") ? "Cluster join: " : "";
    }

    private KeyUtils() {
    }
}

