package org.jfrog.security.util;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.Security;

/**
 * @author Yinon Avraham.
 */
public class BCProviderFactory {

    private BCProviderFactory() {
    }

    // The BC provider is configurable so we keep our own instance (to encapsulate it and not allow configuration
    // changes by others), but except for the configurability it is thread safe so we can keep it static.
    // We prefer to use a static field (instead of an instance field) because the provider is registered in an
    // IdentityHashMap in the JceSecurity when a SecurityKeyFactory is requested.
    private static final BouncyCastleProvider BC_PROVIDER = new BouncyCastleProvider();

    static {
        // BKS-V1 keystore has security breach as described in RTFACT-21610. Next line makes impossible to create it.
        BC_PROVIDER.replace("KeyStore.BKS-V1", "BKS-V1 is forbidden because of CVE-2018-5382");
        Security.addProvider(BC_PROVIDER);
    }

    public static BouncyCastleProvider getProvider() {
        return BC_PROVIDER;
    }
}
