/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto.encrypter;

import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.jfrog.security.crypto.SecretProvider;
import org.jfrog.security.crypto.encrypter.BytesEncrypterBase;

public class DESedeBytesEncrypter
extends BytesEncrypterBase
implements SecretProvider {
    private final SecretKey pbeKey;

    public DESedeBytesEncrypter(@Nonnull SecretKey pbeKey) {
        super(pbeKey.getEncoded());
        this.pbeKey = pbeKey;
    }

    @Override
    public CipherAlg getCipherAlg() {
        return CipherAlg.DESede;
    }

    @Override
    @Nonnull
    public String getKeyId() {
        return this.keyId;
    }

    @Override
    @Nonnull
    public byte[] encrypt(@Nonnull byte[] bytes) {
        return JFrogCryptoHelper.encryptSymmetric(bytes, this.pbeKey);
    }

    @Override
    @Nonnull
    public byte[] decrypt(@Nonnull byte[] bytes) {
        return JFrogCryptoHelper.decryptSymmetric(bytes, this.pbeKey);
    }

    @Override
    @Nonnull
    public SecretKey getSecret() {
        return this.pbeKey;
    }
}

