/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto.encrypter;

import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import org.jfrog.security.crypto.AesEncryptData;
import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.jfrog.security.crypto.SecretProvider;
import org.jfrog.security.crypto.encrypter.BytesEncrypterBase;

public class AesBytesEncrypter
extends BytesEncrypterBase
implements SecretProvider {
    private SecretKey aesKey;

    public AesBytesEncrypter(SecretKey aesKey) {
        super(aesKey.getEncoded());
        this.aesKey = aesKey;
    }

    @Override
    public CipherAlg getCipherAlg() {
        return CipherAlg.AES128;
    }

    @Override
    @Nonnull
    public byte[] encrypt(@Nonnull byte[] bytes) {
        AesEncryptData aesEncryptData = JFrogCryptoHelper.encryptAes(bytes, this.aesKey);
        return aesEncryptData.convertToBytes();
    }

    @Override
    @Nonnull
    public byte[] decrypt(@Nonnull byte[] bytes) {
        AesEncryptData aesEncryptData = new AesEncryptData(bytes);
        return JFrogCryptoHelper.decryptAes(aesEncryptData, this.aesKey);
    }

    @Override
    public SecretKey getSecret() {
        return this.aesKey;
    }
}

