/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.jfrog.security.crypto.JFrogEnvelop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyTool {
    private static final Logger log = LoggerFactory.getLogger(KeyTool.class);
    private final File masterKeyChainDir;
    public final File currentMasterKeyFile;
    private int numOfOldKeys;
    private FileFilter keyFileFilter;

    KeyTool(File currentMasterKeyFile, File masterKeyChainDir, int numOfOldKeys, FileFilter keyFileFilter) {
        this.masterKeyChainDir = masterKeyChainDir != null && masterKeyChainDir.listFiles() != null ? masterKeyChainDir : null;
        this.numOfOldKeys = numOfOldKeys;
        this.keyFileFilter = keyFileFilter;
        if (currentMasterKeyFile == null) {
            currentMasterKeyFile = this.getKeyFiles().get(0);
        }
        this.currentMasterKeyFile = currentMasterKeyFile;
    }

    static long lastModifiedFromName(File f) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmsssSSS");
        String name = f.getName();
        int idx = name.lastIndexOf(".");
        if (idx > 0) {
            Date dt = null;
            try {
                dt = format.parse(name.substring(idx + 1));
                return dt.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return f.lastModified();
    }

    List<File> getKeyFiles() {
        File[] files;
        if (this.masterKeyChainDir != null && this.masterKeyChainDir.listFiles() != null && (files = this.masterKeyChainDir.listFiles()) != null && files.length > 0) {
            Comparator<File> byLastModifiedFromName = Comparator.comparingLong(KeyTool::lastModifiedFromName).reversed();
            return Arrays.stream(files).filter(this.keyFileFilter::accept).filter(File::isFile).sorted(byLastModifiedFromName).limit(this.numOfOldKeys + 1).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    JFrogEnvelop getTopKey() {
        try {
            return JFrogEnvelop.parse(Files.readAllLines(this.currentMasterKeyFile.toPath()).get(0));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("can't read file %s ", this.currentMasterKeyFile), e);
        }
    }
}

