package org.jfrog.security.wrapper;


import java.io.File;
import java.io.FileFilter;

/**
 * @author Dan Feldman
 * A {@link FileFilter} that accepts all file paths that contain the given <code>dbKeyLocation</code>
 */
public class ArtifactoryEncryptionKeyFileFilter implements FileFilter {

    private final String dbKeyLocation;

    public ArtifactoryEncryptionKeyFileFilter(String dbKeyLocation) {
        this.dbKeyLocation = dbKeyLocation;
    }

    @Override
    public boolean accept(File pathname) {
        // Enough for the full path to contain the key location, I don't want endsWith because we save key files
        // with timestamps at the end by default.
        return pathname != null && pathname.getAbsolutePath().contains(dbKeyLocation);
    }
}
