/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package org.jfrog.security.crypto.encrypter;

import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.jfrog.security.crypto.SecretProvider;

import javax.annotation.Nonnull;
import javax.crypto.SecretKey;

public class DESedeBytesEncrypter extends BytesEncrypterBase implements SecretProvider {
    private final SecretKey pbeKey;

    public DESedeBytesEncrypter(@Nonnull SecretKey pbeKey) {
        super(pbeKey.getEncoded());
        this.pbeKey = pbeKey;
    }

    @Override
    public CipherAlg getCipherAlg() {
        return CipherAlg.DESede;
    }

    @Nonnull
    @Override
    public String getKeyId() {
        return keyId;
    }

    @Nonnull
    @Override
    public byte[] encrypt(@Nonnull byte[] bytes) {
        return JFrogCryptoHelper.encryptSymmetric(bytes, pbeKey);
    }

    @Nonnull
    @Override
    public byte[] decrypt(@Nonnull byte[] bytes) {
        return JFrogCryptoHelper.decryptSymmetric(bytes, pbeKey);
    }

    @Nonnull
    @Override
    public SecretKey getSecret() {
        return pbeKey;
    }
}
