package org.jfrog.metadata.client.model;

import org.apache.commons.lang.StringUtils;

public enum SortTypeEnum {

    DESC("desc"), ASC("asc");
    private String aqlName;

    SortTypeEnum(String aqlName) {
        this.aqlName = aqlName;
    }

    public String getAqlName() {
        return aqlName;
    }

    public static SortTypeEnum fromSql(String sql) {
        if (StringUtils.isNotBlank(sql)) {
            for (SortTypeEnum sortTypeEnum : values()) {
                if (sortTypeEnum.aqlName.equals(sql)) {
                    return sortTypeEnum;
                }
            }
            throw new IllegalStateException("Couldn't find enum with the corresponding aql name");
        }
        return null;
    }
}
