package org.jfrog.metadata.client.model;

import com.google.common.base.CaseFormat;
import org.apache.commons.lang.StringUtils;
import org.jfrog.common.JsonUtils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Uriah Levy
 */
public class MetadataFieldRecordingProxy implements InvocationHandler {
    private Set<String> populatedFields = new HashSet<>();
    private MetadataEntity entity;

    public MetadataFieldRecordingProxy(MetadataEntity entity) {
        this.entity = entity;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("toJsonMerge".equals(name)) {
            return JsonUtils.toJsonMerge(entity, populatedFields);
        }
        if (name.startsWith("get") || "toString".equals(name)) {
            return method.invoke(entity, args);
        }
        // setter
        if (name.startsWith("set")) {
            populatedFields.add(StringUtils
                    .substringAfter(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name), "set_"));
        }
        Object returnValue = method.invoke(entity, args);
        // Proxy as builder
        if (returnValue != null && this.entity.getClass().isAssignableFrom(returnValue.getClass())) {
            return proxy;
        }
        return returnValue;
    }

    public String toJsonMerge() {
        return JsonUtils.toJsonMerge(entity, populatedFields);
    }
}
