package org.jfrog.metadata.client.utils;

import lombok.Builder;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.common.JsonUtils;
import org.jfrog.metadata.client.model.MetadataAttribute;
import org.jfrog.metadata.client.model.SortTypeEnum;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Builder
public class AqlLikeBuilder {

    private String collection;
    private Map<String, String> filters;
    private List<MetadataAttribute> includes;
    private Integer limit;
    private Integer offset;
    private SortTypeEnum sortType;
    private List<String> sortAttributes;

    public String query() {
        List<String> attributes = includes.stream().map(MetadataAttribute::getAttributeName)
                .collect(Collectors.toList());

        String query = collection + ".find(" +
                JsonUtils.getInstance().writeValueAsString(filters) + ")" +
                ".include(" + StringUtils.wrap(StringUtils.join(attributes, "\", \""), "\"") + ")";
        if (limit != null) {
            query = query + ".limit(" + limit + ")";
        }
        if (offset != null) {
            query = query + ".offset(" + offset + ")";

        }
        return addSortElementIfNeeded(query);
    }

    private String addSortElementIfNeeded(String collection) {
        if (sortType != null) {
            return collection + ".sort(" + JsonUtils.getInstance()
                    .writeValueAsString(Collections.singletonMap(sortType.getAqlName(), sortAttributes)) + ")";
        }
        return collection;
    }

}