package org.jfrog.metadata.client.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author Elad Hirsch
 *
 */
@EqualsAndHashCode(callSuper = false)
@Data
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@AllArgsConstructor
@NoArgsConstructor
public class MetadataVersionRepo implements MetadataEntity {

    private String name;
    private String url;
    private String type;
    private String leadFilePath;
    private Long downloadCount;

    public MetadataVersionRepo(String name, String leadFilePath) {
        this.name = name;
        this.leadFilePath = leadFilePath;
    }
}
