package org.jfrog.metadata.client.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author Uriah Levy
 */
@EqualsAndHashCode
@Data
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@NoArgsConstructor
public class MetadataVersion implements MetadataEntity {

    private String pkgid;
    private String name;
    private String created;
    private String description;
    private long ordinal;
    private List<MetadataLicense> licenses = new ArrayList<>();
    private List<MetadataVersionRepo> repos;
    private List<MetadataQualifierEntity> qualifiers;
    private List<MetadataFile> files = new ArrayList<>();
    private MetadataVersionStatsEntity stats;
    private Set<MetadataVersionTagEntity> tags;
    private List<MetadataUserProperty> userProperties = new ArrayList<>();
}
