package org.jfrog.metadata.client.model;

import java.util.List;

/**
 * @author Uriah Levy
 */
public interface MetadataPackage extends MetadataEntity {

    String getPkgid();
    void setPkgid(String pkgid);

    String getPackageType();
    void setPackageType(String packageType);

    String getName();
    void setName(String name);

    List<MetadataQualifierEntity> getQualifiers();
    void setQualifiers(List<MetadataQualifierEntity> qualifiers);

    String getDescription();
    void setDescription(String description);

    String getWebsiteUrl();
    void setWebsiteUrl(String websiteUrl);

    String getVcsUrl();
    void setVcsUrl(String vcsUrl);

    String getIssuesUrl();
    void setIssuesUrl(String issuesUrl);

    List<String> getCreatorIdentityUrls();
    void setCreatorIdentityUrls(List<String> creatorIdentityUrls);

    String getCreated();
    void setCreated(String created);

    List<MetadataLicense> getLicenses();
    void setLicenses(List<MetadataLicense> licenses);

    Boolean getRespectsSemver();
    void setRespectsSemver(Boolean respectsSemver);

    String getModified();
    void setModified(String modified);

    String getEdited();
    void setEdited(String edited);

    String getLatestVersion();
    void setLatestVersion(String latestVersion);

    List<MetadataVersion> getVersions();
    void setVersions(List<MetadataVersion> versions);

    MetadataPackageStatsEntity getStats();
    void setStats(MetadataPackageStatsEntity stats);

    int getRating();
    void setRating(int rating);

    List<MetadataPackageTagEntity> getTags();
    void setTags(List<MetadataPackageTagEntity> tags);

    List<MetadataUserProperty> getUserProperties();
    void setUserProperties(List<MetadataUserProperty> userProperties);

    List<PackageInfoSourcesMetadata> getPackageInfoSources();
    void setPackageInfoSources(List<PackageInfoSourcesMetadata> packageInfoSources);

    String toJsonMerge();
}
