package org.jfrog.metadata.client;

import org.jfrog.metadata.client.model.MetadataPackage;
import org.jfrog.metadata.client.model.MetadataVersion;
import org.jfrog.metadata.client.model.MetadataAttribute;
import org.jfrog.metadata.client.model.SortTypeEnum;
import org.jfrog.metadata.client.rest.SearchResponse;

import java.util.List;
import java.util.Map;

/**
 * @author Uriah Levy
 */
public interface SearchClient extends MetadataClientBase<SearchClient> {

    SearchResponse<MetadataPackage> packages(Map<String, String> filters, List<MetadataAttribute> fields, SortTypeEnum sortType,
            List<String> sortAttributes, Integer limit);

    SearchResponse<MetadataVersion> versions(Map<String, String> filters, List<MetadataAttribute> fields, SortTypeEnum sortType,
            List<String> sortAttributes, Integer limit);
}
