package org.jfrog.metadata.client;

import java.io.Closeable;

/**
 * @author Uriah Levy
 */
public interface MetadataClient extends Closeable {

    /**
     * Packages CRUD client
     *
     * @return a @{@link PackageClient} for CRUD package operations
     */
    PackageClient packages();

    /**
     * Versions CRUD client
     *
     * @return a @{@link VersionClient} for CRUD version operations
     */
    VersionClient versions();

    PathsClient paths();

    /**
     * Search client
     *
     * @return a @{@link SearchClient} for search operations
     */
    SearchClient search();

    SystemClient system();

}
