/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs.entities;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.filespecs.entities.Aql;

public class FilesGroup {
    protected Aql aql;
    protected String pattern;
    protected String target;
    protected String props;
    protected String targetProps;
    protected String recursive;
    protected String flat;
    protected String regexp;
    protected String explode;
    protected String[] exclusions;
    protected String[] sortBy;
    protected String sortOrder;
    protected String limit;
    protected String offset;

    public String getAql() {
        if (this.aql != null) {
            return this.aql.getFind();
        }
        return null;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getTarget() {
        return this.target;
    }

    public FilesGroup setAql(Aql aql) {
        this.aql = aql;
        return this;
    }

    public FilesGroup setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public FilesGroup setTarget(String target) {
        this.target = target;
        return this;
    }

    public String getProps() {
        return this.props;
    }

    public FilesGroup setProps(String props) {
        this.props = props;
        return this;
    }

    public String getTargetProps() {
        return this.targetProps;
    }

    public FilesGroup setTargetProps(String targetProps) {
        this.targetProps = targetProps;
        return this;
    }

    public String getRecursive() {
        return this.recursive;
    }

    public FilesGroup setRecursive(String recursive) {
        this.recursive = recursive;
        return this;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public FilesGroup setRegexp(String regexp) {
        this.regexp = regexp;
        return this;
    }

    public String getFlat() {
        return this.flat;
    }

    public FilesGroup setFlat(String flat) {
        this.flat = flat;
        return this;
    }

    public String getExplode() {
        return this.explode;
    }

    public FilesGroup setExplode(String explode) {
        this.explode = explode;
        return this;
    }

    public String[] getSortBy() {
        if (this.sortBy != null) {
            return this.sortBy;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public String[] getExclusions() {
        return this.exclusions;
    }

    public FilesGroup setExclusions(String[] exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public String getExclusion(int index) {
        return this.exclusions[index];
    }

    public FilesGroup setSortBy(String[] sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public FilesGroup setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public String getOffset() {
        return this.offset;
    }

    public FilesGroup setOffset(String offset) {
        this.offset = offset;
        return this;
    }

    public String getLimit() {
        return this.limit;
    }

    public FilesGroup setLimit(String resultLimit) {
        this.limit = resultLimit;
        return this;
    }

    public String toString() {
        return "FilesGroup{aql=" + this.aql + ", pattern='" + this.pattern + '\'' + ", target='" + this.target + '\'' + ", props='" + this.props + '\'' + ", targetProps='" + this.targetProps + '\'' + ", recursive='" + this.recursive + '\'' + ", flat='" + this.flat + '\'' + ", regexp='" + this.regexp + '\'' + ", explode='" + this.explode + '\'' + ", exclusions='" + Arrays.toString(this.exclusions) + '\'' + ", sortBy='" + Arrays.toString(this.sortBy) + '\'' + ", sortOrder='" + this.sortOrder + '\'' + ", offset='" + this.offset + '\'' + ", limit='" + this.limit + '\'' + '}';
    }

    public SpecType getSpecType() {
        if (StringUtils.isNotEmpty((String)this.pattern)) {
            return SpecType.PATTERN;
        }
        if (StringUtils.isNotEmpty((String)this.getAql())) {
            return SpecType.AQL;
        }
        return null;
    }

    public static enum SpecType {
        PATTERN,
        AQL;

    }
}

