/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.jfrog.filespecs.FileSpecsParsingUtils;
import org.jfrog.filespecs.aql.AqlConverter;
import org.jfrog.filespecs.entities.FilesGroup;
import org.jfrog.filespecs.entities.InvalidFileSpecException;
import org.jfrog.filespecs.validation.SearchBasedSpecValidator;
import org.jfrog.filespecs.validation.SpecsValidator;

public class FileSpec {
    private List<FilesGroup> files = new ArrayList<FilesGroup>();

    public List<FilesGroup> getFiles() {
        return this.files;
    }

    public void addFilesGroup(FilesGroup filesGroup) {
        this.files.add(filesGroup);
    }

    public List<String> toAql() throws InvalidFileSpecException {
        SearchBasedSpecValidator specsValidator = new SearchBasedSpecValidator();
        ((SpecsValidator)specsValidator).validate(this);
        ArrayList<String> aqls = new ArrayList<String>();
        for (FilesGroup file : this.getFiles()) {
            aqls.add(AqlConverter.convertFilesGroupToAql(file));
        }
        return aqls;
    }

    public static FileSpec fromString(String specStr) throws InvalidFileSpecException {
        FileSpec fileSpec;
        ObjectMapper mapper = new ObjectMapper();
        specStr = specStr.replace("\\", "\\\\");
        try {
            fileSpec = (FileSpec)mapper.readValue(specStr, FileSpec.class);
        }
        catch (JsonProcessingException e) {
            throw new InvalidFileSpecException(String.format("Parsing of file spec failed:\n%s", specStr), e);
        }
        FileSpecsParsingUtils.pathToUnixFormat(fileSpec);
        return fileSpec;
    }
}

