/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core.collectors;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Optional;
import org.jfrog.support.common.LogsFilesMatcher;
import org.jfrog.support.common.config.SystemLogsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilesMatcher
implements LogsFilesMatcher {
    private final Logger log = LoggerFactory.getLogger(DefaultFilesMatcher.class);

    @Override
    public boolean isMatch(Path filePath, SystemLogsConfiguration configuration) {
        String logsFilesPattern = "glob:**.log";
        String zippedLogsPattern = "glob:**.zip";
        this.log.debug("Matching file {}", (Object)filePath);
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(logsFilesPattern);
        PathMatcher zippedPathMatcher = FileSystems.getDefault().getPathMatcher(zippedLogsPattern);
        if (pathMatcher.matches(filePath) || zippedPathMatcher.matches(filePath)) {
            long fileModifiedTime = this.getFileModifiedTimeAsEpoch(filePath);
            long minTime = this.getMinTimeAsEpoch(configuration);
            long maxTime = this.getMaxTimeAsEpoch(configuration);
            return this.isDateBetween(fileModifiedTime, minTime, maxTime);
        }
        this.log.debug("{} didn't matched any pattern by default collect the file as well.", (Object)filePath);
        return true;
    }

    private boolean isDateBetween(long fileModifiedTime, long minTime, long maxTime) {
        return fileModifiedTime >= minTime && fileModifiedTime <= maxTime;
    }

    private long getMaxTimeAsEpoch(SystemLogsConfiguration logsSettings) {
        return logsSettings.getEndDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(23, 59, 59).toEpochSecond(ZoneOffset.UTC) * 1000L;
    }

    private long getMinTimeAsEpoch(SystemLogsConfiguration logsSettings) {
        return logsSettings.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(0, 0, 0).toEpochSecond(ZoneOffset.UTC) * 1000L;
    }

    private Long getFileModifiedTimeAsEpoch(Path path) {
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            this.log.debug("File's last modified time: {}", (Object)lastModifiedTime);
            return Optional.ofNullable(lastModifiedTime).map(FileTime::toMillis).orElse(0L);
        }
        catch (IOException e) {
            this.log.warn("Cannot get file's last modified time: {}", (Object)e.getMessage());
            this.log.debug("Exception:", (Throwable)e);
            return 0L;
        }
    }
}

