/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.utils;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.stream.IntStream;

public class StringBuilderWrapper
implements Serializable,
CharSequence {
    public static final String NEW_LINE = StringBuilderWrapper.getLineSeparator();
    private final StringBuilder sb;

    private static String getLineSeparator() {
        return System.getProperty("line.separator") != null ? System.getProperty("line.separator") : "\n";
    }

    public StringBuilderWrapper() {
        this.sb = new StringBuilder();
    }

    public StringBuilderWrapper(String string) {
        this.sb = new StringBuilder(string);
    }

    public StringBuilderWrapper(CharSequence charSequence) {
        this.sb = new StringBuilder(charSequence);
    }

    public StringBuilderWrapper append(String content) {
        if (!Strings.isNullOrEmpty((String)content)) {
            this.sb.append(content);
            this.sb.append(NEW_LINE);
            this.sb.append(NEW_LINE);
        }
        return this;
    }

    public void append(Object object) {
        if (object != null) {
            this.sb.append(object);
            this.sb.append(NEW_LINE);
        }
    }

    public void append(Object title, Object content) {
        if (title != null) {
            this.sb.append(title);
            this.sb.append(": ");
            this.sb.append(content);
            this.sb.append(NEW_LINE);
        }
    }

    public void newLine() {
        this.sb.append(NEW_LINE);
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        return this.sb.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.sb.codePoints();
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }
}

