/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core.collectors.system.info;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.jfrog.common.Strings;
import org.jfrog.support.common.core.collectors.system.info.BasePropInfoGroup;
import org.jfrog.support.common.core.collectors.system.info.ClassPathPropInfo;
import org.jfrog.support.common.core.collectors.system.info.HostPropInfo;
import org.jfrog.support.common.core.collectors.system.info.InfoObject;
import org.jfrog.support.common.core.collectors.system.info.JavaSysPropInfo;
import org.jfrog.support.common.core.collectors.system.info.UserPropInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonInfoWriter {
    private static final Logger log = LoggerFactory.getLogger(CommonInfoWriter.class);
    private List<Class<? extends BasePropInfoGroup>> infoGroup;
    public static final String listFormat = "   %1$-70s| %2$s%n";

    public void writeInfo() throws IllegalAccessException, InstantiationException {
        if (log.isInfoEnabled()) {
            log.info(this.getInfo());
        }
    }

    public String getInfo() throws IllegalAccessException, InstantiationException {
        return this.getInfoString();
    }

    public String getInfoString() throws InstantiationException, IllegalAccessException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%n%n SYSTEM INFORMATION DUMP%n", new Object[0]));
        sb.append(String.format(" =======================%n", new Object[0]));
        for (Class<? extends BasePropInfoGroup> clazz : this.getGroups()) {
            BasePropInfoGroup group = clazz.newInstance();
            if (!group.isInUse()) continue;
            sb.append(String.format("%n ", new Object[0])).append(group.getGroupName()).append(String.format("%n", new Object[0]));
            sb.append(String.format(" ========================%n", new Object[0]));
            for (InfoObject infoObject : group.getInfo(false)) {
                String propertyName = infoObject.getPropertyName();
                String value = infoObject.getPropertyValue();
                if (CommonInfoWriter.shouldMaskValue(propertyName)) {
                    value = Strings.mask((String)value);
                } else if (clazz.equals(JavaSysPropInfo.class) && CommonInfoWriter.shouldMaskValue(value)) {
                    value = Strings.maskKeyValue((String)value);
                }
                if (propertyName.matches(".*class\\.?path.*")) {
                    this.splitLine(sb, propertyName, value);
                    continue;
                }
                sb.append(String.format(listFormat, propertyName, value));
            }
        }
        return sb.toString();
    }

    public Map<String, Multimap<String, String>> getInfoMap() throws InstantiationException, IllegalAccessException {
        HashMap<String, Multimap<String, String>> info = new HashMap<String, Multimap<String, String>>();
        for (Class<? extends BasePropInfoGroup> clazz : this.getGroups()) {
            BasePropInfoGroup group = clazz.newInstance();
            if (!group.isInUse()) continue;
            ArrayListMultimap currentMap = ArrayListMultimap.create();
            info.put(group.getGroupName(), (Multimap<String, String>)currentMap);
            for (InfoObject infoObject : group.getInfo(true)) {
                String propertyName = infoObject.getPropertyName();
                String value = infoObject.getPropertyValue();
                if (CommonInfoWriter.shouldMaskValue(propertyName)) {
                    value = Strings.mask((String)value);
                } else if (clazz.equals(JavaSysPropInfo.class) && CommonInfoWriter.shouldMaskValue(value)) {
                    value = Strings.maskKeyValue((String)value);
                }
                if (propertyName.matches(".*class\\.?path.*")) {
                    this.splitLine((Multimap<String, String>)currentMap, propertyName, value);
                    continue;
                }
                currentMap.put((Object)propertyName, (Object)value);
            }
        }
        return info;
    }

    private void splitLine(StringBuilder sb, String propertyName, String value) {
        String multiValueSeparator = SystemUtils.IS_OS_WINDOWS ? ";" : ":";
        String[] separateValues = value.split(multiValueSeparator);
        for (int i = 0; i < separateValues.length; ++i) {
            String separateValue = separateValues[i];
            sb.append(String.format(listFormat, i == 0 ? propertyName : "", separateValue));
        }
    }

    private void splitLine(Multimap<String, String> map, String propertyName, String value) {
        String multiValueSeparator = SystemUtils.IS_OS_WINDOWS ? ";" : ":";
        String[] separateValues = value.split(multiValueSeparator);
        for (int i = 0; i < separateValues.length; ++i) {
            String separateValue = separateValues[i];
            map.put((Object)propertyName, (Object)separateValue);
        }
    }

    public static boolean shouldMaskValue(String propertyKey) {
        String propKeyLower = propertyKey.toLowerCase();
        return propKeyLower.contains("password") || propKeyLower.contains("secret") || propKeyLower.contains("key") || CommonInfoWriter.getMaskedKeys().contains(propertyKey);
    }

    protected static Set<String> getMaskedKeys() {
        return Sets.newHashSet();
    }

    protected List<Class<? extends BasePropInfoGroup>> getGroups() {
        return ImmutableList.of(ClassPathPropInfo.class, JavaSysPropInfo.class, UserPropInfo.class, HostPropInfo.class);
    }
}

