/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common.core.collectors.system.info;

/**
 * The base class of all the information groups
 *
 * @author Noam Tenne
 */
public abstract class BasePropInfoGroup implements PropInfoGroup {

    /**
     * Returns a system property via the property name
     *
     * @param propName The property name
     * @return String - The property value
     */
    public static String getSystemProperty(String propName) {
        if ((propName == null) || ("".equals(propName))) {
            throw new IllegalArgumentException("Property name cannot be empty or null");
        }
        return System.getProperty(propName);
    }

    /**
     * Basic implementation of the getInfo method
     *
     * @return InfoObject[] - An empty info object array
     */
    @Override
    public InfoObject[] getInfo(boolean isSupportBundles) {
        return new InfoObject[]{};
    }

    /**
     * @return whether this info group should be displayed.
     */
    public boolean isInUse() {
        return true;
    }

    protected abstract String getGroupName();
}