/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common.config;

import org.joda.time.DateTime;
import org.jfrog.support.common.CollectConfiguration;

import java.util.Date;

/**
 * Provides configuration for system logs collection
 *
 * @author Michael Pasternak
 */
public class SystemLogsConfiguration extends CollectConfiguration {

    private Date startDate; // TODO: consider using ZonedDateTime (if needed)
    private Date endDate;   // TODO: consider using ZonedDateTime (if needed)
    private Integer daysCount;

    /**
     * we enable all collectors by default (see in #RTFACT-8106),
     * if no date range is specified, we'll collect logs for last
     * day only
     */
    public SystemLogsConfiguration() {
        endDate = new Date();
        startDate = new DateTime(endDate).minusDays(1).toDate();
    }

    /**
     * @param enabled whether SystemLogs configuration is enabled
     * @param startDate collect logs from
     * @param endDate collect logs to
     */
    public SystemLogsConfiguration(boolean enabled, Date startDate, Date endDate) {
        super(enabled);

        this.startDate = startDate;
        this.endDate = endDate;
        this.daysCount = null;
    }

    /**
     * @param enabled whether SystemLogs configuration is enabled
     * @param daysCount amount of days eligible for logs collection
     */
    public SystemLogsConfiguration(boolean enabled, Integer daysCount) {
        super(enabled);

        this.daysCount = daysCount;
        this.startDate = null;
        this.endDate = null;
    }

    /**
     * @return StartDate
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * @return EndDate
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * @return DaysCount
     */
    public Integer getDaysCount() {
        return daysCount;
    }
}
