/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoProxyHostsEvaluator {
    private static final Logger log = LoggerFactory.getLogger(NoProxyHostsEvaluator.class);
    private final String noProxyHosts;

    public NoProxyHostsEvaluator(@Nullable String noProxyHosts) {
        this.noProxyHosts = this.getCleanedNoProxyHostsList(noProxyHosts);
    }

    public String getNoProxyHosts() {
        return this.noProxyHosts;
    }

    public boolean shouldBypassProxy(@Nonnull String host) {
        String noProxyHostsList = this.noProxyHosts;
        if (!noProxyHostsList.isEmpty()) {
            if (host.matches("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}(:[0-9]{1,5})??$") || host.matches("^(?:[a-fA-F0-9]{1,4}:){7}[a-fA-F0-9]{1,4}(:[0-9]{1,5})??$")) {
                return this.match(noProxyHostsList, host);
            }
            return this.isHostAndPortMatch(noProxyHostsList, host);
        }
        return false;
    }

    private boolean isHostAndPortMatch(@Nonnull String noProxyHostsList, @Nonnull String host) {
        int depth = 0;
        String originalHost = host;
        while (host.matches("^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z]{2,}(:[0-9]{1,5})??$") && depth < 128) {
            ++depth;
            if (this.match(noProxyHostsList, host)) {
                return true;
            }
            host = host.replaceFirst("^[a-z0-9]+(-[a-z0-9]+)*\\.", "");
        }
        String[] noProxyArray = noProxyHostsList.split(",");
        return depth > 0 && this.suffixMatch(originalHost, noProxyArray);
    }

    private boolean match(@Nonnull String noProxyHostsList, @Nonnull String host) {
        if (noProxyHostsList.matches(".*(^|,)\\Q" + host + "\\E($|,).*")) {
            return true;
        }
        int portSplitIndex = host.indexOf(58);
        return portSplitIndex > -1 && noProxyHostsList.contains(host.substring(0, portSplitIndex)) && !noProxyHostsList.contains(host.substring(0, portSplitIndex + 1));
    }

    private String getCleanedNoProxyHostsList(@Nullable String noProxyHostsList) {
        if (noProxyHostsList == null) {
            return "";
        }
        String updatedString = noProxyHostsList.trim().replaceAll("\\s+", "").replaceAll("\\*\\.", "").replaceAll(",\\.", ",");
        if (updatedString.startsWith(".")) {
            return updatedString.substring(1);
        }
        return updatedString;
    }

    private boolean suffixMatch(String host, String[] noProxyArray) {
        for (String proxy : noProxyArray) {
            if (!proxy.contains(".") || !host.endsWith(proxy)) continue;
            return true;
        }
        return false;
    }
}

