/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http.auth;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PreemptiveAuthInterceptor.class);

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        AuthState authState = clientContext.getTargetAuthState();
        if (authState.getAuthScheme() == null) {
            HttpHost targetHost;
            CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
            Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = clientContext.getTargetHost()).getHostName(), targetHost.getPort()));
            if (creds == null) {
                log.debug("No credentials found for host " + targetHost);
            } else {
                log.debug("Updating credentials for host " + targetHost);
                authState.update((AuthScheme)new BasicScheme(), creds);
            }
        }
    }
}

